<?php

namespace App\Http\Controllers;

use App\Models\Appointment;
use Illuminate\Http\Request;
use App\Mail\AppointmentConfirmation;
use App\Models\User;
use Illuminate\Support\Facades\Mail;
use App\Notifications\WhatsAppNotification;
use Twilio\Rest\Client;
class AppointmentController extends Controller
{

    public function store(Request $request)
    {
        $request->validate([
            'doctorName' => 'required|string',
            'treatment' => 'required|string',
            'appointmentdate' => 'required|date', 
            'appointmenttime' => 'required|date_format:H:i',
            'patientName' => 'required|string',
            'patientPhone' => 'required|regex:/^(\+\d{1,3}[- ]?)?\d{10}$/',
        ]);

        // Save the appointment
        $data = $request->all();
        $appointment = new Appointment($data);
        $appointment->save();

        // Send confirmation email (if needed)
        Mail::to(['madalasah@gmail.com', 'work.sartaj@gmail.com'])
            ->send(new AppointmentConfirmation($appointment));

        // Send WhatsApp notification to the admin
        $admin = User::find(1); // Replace with your admin retrieval logic

        // Use the WhatsApp notification to send the message
        $admin->notify(new WhatsAppNotification());

        return view('frontend.pages.thankyou')->with(['modal' => true, 'appointment' => $appointment]);
    }


    
    
}



 
