<?php

namespace App\Http\Controllers;

use App\Models\Department;
use App\Models\Doctor;
use App\Models\ServicesSeo;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class DepartmentController extends Controller
{
    public function create(){
        return view('backend.admin.department.create');
    }

    public function store(Request $request){
         
        $validateData = $request->validate([
            'name' => 'required',
            'des' => 'required|string',
            'image' => 'required',
        ]);
        
        $data = new Department([
            'name'=>$validateData['name'],
            'des'=> $validateData['des'],
            'image'=>$validateData['image'],

        ]);
       
        $data->save();
        return redirect()->back()->with('success','Department has been successfully added');
    }


    public function alldepartment(Request $request){
        $departments = Department::get();
        return view('backend.admin.department.alldepartments',compact('departments'));
    }

    public function edit(Request $request ,$id){
        $department = Department::findOrFail($id);
        return view('backend.admin.department.edit',compact('department'));
    }

    public function update(Request $request){
        $validateData = $request->validate([
            'id' => 'required|integer',  
            'name' => 'required',
            'des' => 'required|string',
            'image' => 'required',
        ]);
        
        $id = $validateData['id'];  
        
        $data = Department::findOrFail($id);
        $data->name = $validateData['name'];
        $data->des = $validateData['des'];
        $data->image = $validateData['image'];
    
        $data->save();
        return redirect()->back()->with('success', 'Department has been successfully updated');
    }


    public function delete($id){
        $department = Department::findOrfail($id);
        $department->delete();
        return redirect()->back()->with('success', 'Department has been successfully deleted');
    }
    


    
    public function show($id){
        $department = Department::with('services')->where('name',$id)->first();
        if (!$department) {
            abort(404);
        }
      
        $departments = Department::get();
        $doctors = Doctor::get();
        // $serviceSeo = ServicesSeo::where('metaTitle',$id)->
         
        return view('frontend.pages.services.show',compact('department','departments','doctors'));
    }
    
 
    public function icu(Request $request){
        $doctors = Doctor::get();
        $department = Department::get();
        return view('frontend.pages.services.icu',compact('doctors','department'));
    }

    public function xRayLab(Request $request){
        $doctors = Doctor::get();
        $department = Department::get();
        return view('frontend.pages.services.labandx-ray',compact('doctors','department'));

    }

    public function dietians(Request $request){
        $doctor = Doctor::where('doctorfname', 'Dr.Deepika')->first();
         $department = Department::get();
        return view('frontend.pages.services.dietians',compact('doctor','department'));
    }
    

}
