<?php

namespace App\Http\Controllers;

use App\Models\DoctorSeo;
use Illuminate\Http\Request;

class DoctorSeoController extends Controller
{
    public function create(){
        return view('backend.admin.Seo.doctors.createdoctorSeo');
    }

    public function store(Request $request){
        $validateData = $request->validate([
            'doctor_id' => 'required',
            'metaTitle' => 'required | max:70',
            'metaDescription' => 'required | max:170'
        ]);
        $data = new DoctorSeo($validateData);
        $data->save();
        return redirect()->back()->with('success','Meta Title and Meta Description have been successfully added');
    }



}
