<?php

namespace App\Http\Controllers;

use App\Models\Department;
use App\Models\Doctor;
use App\Models\DoctorTimeTable;
use Illuminate\Http\Request;

class DoctorTimeTableController extends Controller
{
   

    public function index(Request $request)
{
    $doctors = Doctor::get();
    $doctorTimes = DoctorTimeTable::get();

    // Create an array to store doctor timetables
    $doctorTimetables = [];

    // Populate doctor timetables based on doctor times
    foreach ($doctors as $doctor) {
        $doctorTimetables[$doctor->id] = [
            'name' => $doctor->doctorfname . ' ' . $doctor->doctorlname,
            'specialty' => $doctor->specialty,
            'consultationTiming' => '',  
            'morningTiming' => '',  
            'eveningTiming' => '',  
        ];
    }

    // Populate the morning and evening timings based on doctor times
    foreach ($doctorTimes as $doctorTime) {
        $doctorId = $doctorTime->doctor_id;
        $day = $doctorTime->day;

        // Assuming "morningTiming" and "eveningTiming" columns contain timing data
        $morningTiming = $doctorTime->morningTiming;
        $eveningTiming = $doctorTime->eveningTiming;

        // Update the timings in the $doctorTimetables array
        if (isset($doctorTimetables[$doctorId])) {
            $doctorTimetables[$doctorId]['morningTiming'] = $morningTiming;
            $doctorTimetables[$doctorId]['eveningTiming'] = $eveningTiming;
        }
    }

    return view('frontend.pages.doctor.doctors-timetable', compact('doctorTimetables', 'doctors'));
}



   

    public function create(Request $request)
    {
        $doctors = Doctor::get();
        $departments = Department::get();
        $doctorTime = DoctorTimeTable::get();
        return view('backend.admin.doctorTiming.create', compact('doctors', 'departments','doctorTime'));
    }



    public function store(Request $request)
{
    $validateData = $request->validate([
        'morningTiming' => 'required',
        'eveningTiming' => 'required',
        'dname' => 'required', // Change this to 'dname' to match the select field name
        'department' => 'required', // Change this to 'department' to match the select field name
    ]);

    $data = [
        'consultation' => 'consultation',
        'morningTiming' => $validateData['morningTiming'],
        'eveningTiming' => $validateData['eveningTiming'],
        'doctor_id' => $validateData['dname'], // Change 'doctor_id' to 'dname' to match the select field name
        'department_id' => $validateData['department'], // Change 'department_id' to 'department' to match the select field name
    ];

    $doctorTime = new DoctorTimeTable($data);
    $doctorTime->save();

    return redirect()->back()->with('success', 'Doctor Time Has been Added Successfully');
}

public function showTimeTabel(Request $request){
    $doctorTimeTabels = DoctorTimeTable::get();
    return view('backend.admin.doctorTiming.show',compact('doctorTimeTabels'));
}
    

public function edit($id){
    $doctorsTimes = DoctorTimeTable::findOrFail($id);
    $doctors = Doctor::all();
    $departments = Department::all();
    $doctorsTimes->dname = $doctorsTimes->doctor_id; 
    $doctorsTimes->department = $doctorsTimes->department_id;
    return view('backend.admin.doctorTiming.edit',compact('doctorsTimes','doctors','departments'));
}


public function update(Request $request , $id){

    $doctorsTime = DoctorTimeTable::findOrFail($id);
    $validateData = $request->validate([
        'morningTiming' => 'required',
        'eveningTiming' => 'required',
        'dname' => 'required', 
        'department' => 'required',  
    ]);
    $data = [
        'consultation' => 'consultation',
        'morningTiming' => $validateData['morningTiming'],
        'eveningTiming' => $validateData['eveningTiming'],
        'doctor_id' => $validateData['dname'],  
        'department_id' => $validateData['department'],  
    ];
    $doctorsTime->update($data);
    return redirect()->back()->with('success', 'Doctor Time Has been Updated Successfully');
}






}
