<?php

namespace App\Http\Controllers;
use App\Models\Gallery;
use Illuminate\Http\Request;

class GalleryController extends Controller
{
    public function create(){
        return view('backend.admin.gallery.create');
    }

    public function upload(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', 
        ]);
        $imageName = time() . '.' . $request->image->extension();
        $request->image->storeAs('public', $imageName);
        $image = new Gallery();
        $image->path = $imageName;
        $image->save();
        return redirect()->route('gallery.create')->with('success', 'Image uploaded successfully.');
    }



}
