<?php

namespace App\Http\Controllers;

use App\Models\Department;
use App\Models\HealthCamp;
use Illuminate\Http\Request;

class HealthCampController extends Controller
{
    

    public function create1(){
        return view('backend.admin.freeHealthCamp.create');
    }
    
    
    public function sartaj(){
        return view('backend.admin.freeHealthCamp.create1');
    }
    public function store(Request $request) {

        $validatedData = $request->validate([
            'name' => 'required|string',
            'location' => 'required|string',
            'campdate' => 'required|date',
            'camptime' => 'required|date_format:H:i',
            'campimage' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', // Make the image field optional
            'des' => 'required|string',
        ]);

        $campData = [
            'name' => $validatedData['name'],
            'location' => $validatedData['location'],
            'campdate' => $validatedData['campdate'],
            'des' => $validatedData['des'],
            'camptime' => $validatedData['camptime'],
        ];

        if ($request->hasFile('campimage')) {
            $image = $request->file('campimage');
            $name = time() . '.' . $image->getClientOriginalExtension();
            $path = public_path('camp/images');
            $image->move($path, $name);
            $campData['campimage'] = $name;
        }
        

        $campData = new HealthCamp($campData);
        $campData->save();
        return redirect()->back()->with('success','Health Camp Successfully Added');
    

    }

    public function show(Request $request){
        $data = HealthCamp::all();
        
        return view('backend.admin.freeHealthCamp.show',compact('data'));
    }



    public function edit($id){
        $camp = HealthCamp::findOrFail($id);
        return view('backend.admin.freeHealthCamp.edit',compact('camp'));
    }
    public function update(Request $request, $id)
    {
        $data = HealthCamp::findOrFail($id);
        $validatedData = $request->validate([
            'name' => 'required|string',
            'location' => 'required|string',
            'campdate' => 'required|date',
            'camptime' => 'required',
            'campimage' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'des' => 'required|string',
        ]);
    
        $campData = [
            'name' => $validatedData['name'],
            'location' => $validatedData['location'],
            'campdate' => $validatedData['campdate'],
            'des' => $validatedData['des'],
            'camptime' => $validatedData['camptime'],
        ];
    
        // Check if a new image file has been uploaded
        if ($request->hasFile('campimage')) {
            $image = $request->file('campimage');
            $name = time() . '.' . $image->getClientOriginalExtension();
            $path = public_path('camp/images');
            $image->move($path, $name);
    
            // Delete the old image if it exists
            if ($data->campimage) {
                $oldImagePath = public_path('camp/images/' . $data->campimage);
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }
    
            // Update the campimage field with the new image name
            $campData['campimage'] = $name;
        }
    
        $data->update($campData);
    
        return redirect()->back()->with('success', 'Health Camp Update Successfully');
    }
    

    public function showFront($id){

        $campdetails = HealthCamp::findOrFail($id);
        $recent = HealthCamp::latest()->take(3)->get();
        $departments = Department::get();
        return view('frontend.pages.healthCamp.show',compact('campdetails','recent','departments'));
    }
    
}
