<?php

namespace App\Http\Controllers;

use App\Models\Department;
use App\Models\Doctor;
use App\Models\Gallery;
use App\Models\HealthCamp;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index(Request $request){
        $departments = Department::get();
        $doctors = Doctor::get();
        $healthCamp = HealthCamp::orderBy('campdate', 'desc')
    ->take(3)
    ->get();
        return view('frontend.pages.index', compact('departments','doctors','healthCamp'));
    }


    public function contact(){
        return view('frontend.pages.contact');
    }


    public function termCondition(){
        return view('frontend.pages.term$conditioin');
    }


    public function privacy(){
        return view('frontend.pages.privacy');
    }
    

}
