<?php

namespace App\Http\Controllers;

use App\Models\PatientFeedBack;
use Illuminate\Http\Request;


class PatientFeedBackController extends Controller
{
    public function hospitalfeedback()
    {
        return view('hospitalfeedback');
    }

    public function store(Request $request)
    {
        $validateData = $request->validate([
            'name' => 'required',
            'phone' => 'required',
            'email' => 'nullable',
            'q1' => 'required',
            'q2' => 'required',
            'q3' => 'required',
            'q4' => 'required',
            'q5' => 'required',
            'q6' => 'required',
            'q7' => 'required',
            'q8' => 'required',
            'q9' => 'required',
            'suggestion' => 'nullable',
        ]);
        $feedbackRatings = array_values($validateData);
        $positiveRatings = ['Very Good', 'Good', 'Fair'];
        $negativeRatings = ['Poor', 'Average'];
        $isPositive = count(array_intersect($feedbackRatings, $positiveRatings)) > 0;
        $isNegative = count(array_intersect($feedbackRatings, $negativeRatings)) > 0;
        if ($isPositive) {
            $data = new PatientFeedBack($validateData);
            $data->save();
            return redirect()->back()->with('success', 'Your feedback has been submitted successfully.')->with('positive', true);
        } elseif ($isNegative) {
            $data = new PatientFeedBack($validateData);
            $data->save();
            return redirect()->back()->with('error', 'Your feedback indicates areas of improvement. We apologize for any inconvenience.');
        }
        return redirect()->back()->with('success', 'Your feedback has been submitted successfully.');
    }
}
