<?php

namespace App\Http\Controllers;

use App\Models\Department;
use App\Models\ServicesSeo;
use Illuminate\Http\Request;

class ServicesSeoController extends Controller
{
    public function create(Request $request){
        $allServices = Department::get();
        return view('backend.admin.Seo.Services.create', compact('allServices'));
    }

    public function store(Request $request){
        $valdiateAllData = $request->validate([
            'department_id'=>'required',
            'metaTitle'=>'required | max:70',
            'metaDescription'=>'required | max:170',
        ]);
        
        $data = New ServicesSeo($valdiateAllData);
        $data->save();
        return redirect()->back()->with('success','You have been successfully added');


    }



}
