<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DepartmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $department = [
            [
                'name' => 'Internal Medicine',
                'des' => "Here at Madālasā Hospital, we have excellent team of doctors who provide superior care & management. Our services are not just limited to the diagnosis and treatment of various diseases but also extend to creating awareness about a healthy lifestyle & prevention of non-communicable diseases. Internal Medicine deals with the prevention, diagnosis, and treatment of infective & noninfective illnesses in adult patients. Internists (physicians) are skilled in managing patients who are suffering from undifferentiated or multi-system diseases. Madalasa Hospital provides diagnosis, treatment, and management of lifestyle disorders- Diabetes, Hypertension. best hospital in Gurgaon.

                Internal medicine is a crucial specialty that deals with the prevention, diagnosis, and treatment of adult diseases. At Madalasa Hospital, we are committed to providing comprehensive and personalized care to our patients, using the latest diagnostic tools and treatment options.
                
                Our internal medicine team consists of highly skilled and experienced physicians who are dedicated to providing top-notch care to our patients. Our team is trained in a wide range of medical areas, including cardiology, gastroenterology, nephrology, endocrinology, pulmonology, and infectious diseases, among others.
                
                We take a patient-centered approach to care, which means that we treat each patient as a unique individual with their own specific needs and medical history. We believe in open communication and work closely with our patients to develop individualized treatment plans that meet their health goals and improve their quality of life.
                
                Our Internal Medicine Services Include:
                Preventive health screenings: We offer a wide range of preventive health screenings, including blood pressure checks, cholesterol screenings, cancer screenings, and vaccinations.
                Diagnosis and treatment of chronic conditions: We provide comprehensive care for chronic conditions such as diabetes, hypertension, heart disease, and asthma.
                Management of acute illnesses: Our team is skilled in the diagnosis and treatment of acute illnesses such as influenza, pneumonia, and urinary tract infections.
                Geriatric care: We provide specialized care for older adults, including the diagnosis and management of age-related conditions such as arthritis, osteoporosis, and dementia.
                Women's health: Our team provides comprehensive women's health services, including gynecological exams, contraception counseling, and menopause management.
                At Madalasa Hospital, we understand that the key to providing excellent internal medicine care is staying up-to-date with the latest medical advancements and techniques. Our team is committed to ongoing education and training to ensure that we are providing the highest quality care to our patients. If you are in need of internal medicine services, we invite you to schedule an appointment with one of our highly skilled physicians. We look forward to helping you achieve optimal health and well-being.",
                'image' => 'https://img.icons8.com/ios/50/737373/hand-with-a-pill--v1.png',

            ],
            [
                'name' => 'Gynaecology',
                'des'=>"At Madālasā hospital we offer full spectrum of general and specialty obstetrics and gynecological care. The hospital provides excellent maternity care, maternity services, and delivery facility and promotes Normal delivery with the help of experienced Obstetricians and Gynecologists. We are committed to promoting women’s health by providing them with a complete range of health services with the empathy that they deserve.

                Our Services also include prenatal and postnatal care, post-menopausal care, detection and treatment of sexually transmitted diseases, infertility clinic, family planning, preventive care including Pap test screening, and Maternity Care. We have a fully equipped Labor room for the 24-hour delivery facility, Emergency/Elective Cesarean operation, and Operational facilities for varied gynecological problems like menstrual abnormalities, prolapse uterus, fibroids, and other tumors of the uterus and ovaries.
                
                Best Obstetrics & Gynaecology Hospital in Gurgaon. Madalasa Hospital – Find the best gynecologist in Gurgaon. Best Gynecology Hospital",
                'image'=>'https://img.icons8.com/ios/50/737373/pregnant.png',
            ],
            [
                'name' => 'Surgery',
                'des'=>"Surgery is a medical or dental specialty that uses operative manual and instrumental techniques on a person to investigate or treat a pathological condition such as a disease or injury, to help improve bodily function, appearance, or to repair unwanted ruptured areas.Madalsa Hospital is proud to offer a comprehensive range of surgical services to our patients. Our experienced team of surgeons, nurses, and support staff are dedicated to providing the highest quality of care using the latest surgical techniques and technology. Here are some of the surgical services we offer Laparoscopic Surgery
                A minimally invasive surgery that involves making small incisions in the abdomen to insert a laparoscope and other specialized surgical instruments.
                
                Bariatric Surgery
                A surgery performed on people who are obese to reduce the size of the stomach or reroute the small intestine to limit the amount of food that can be consumed
                
                Plastic Surgery
                A surgical specialty that involves reconstructing or reshaping parts of the body for cosmetic or functional purposes, such as breast augmentation, rhinoplasty, and facelift.
                
                Orthopedic Surgery
                A surgery that involves treating injuries or disorders of the musculoskeletal system, including bones, joints, muscles, and ligaments.
                
                Cardiothoracic Surgery
                A surgery performed on the organs in the chest cavity, such as the heart, lungs, and esophagus.
                
                Neurosurgery
                A surgery that involves treating disorders of the nervous system, including the brain, spinal cord, and peripheral nerves.
                
                ",
                'image'=>'	https://img.icons8.com/ios/50/737373/surgery.png',
            ],
            [
                'name' => 'Orthopaedics',
                'des'=>"Bone and joint injuries are very painful and debilitating. It is always important to seek early and specialized treatment to prevent long term sequelae. Madālasā hospital is a well-equipped hospital for orthopedics, as well as trauma care, bone disease, knee replacement surgery and joint surgery. We have orthopedic facilities to deal with any kind of orthopedic problems, major or minor. Our specialists are well-qualified to provide the best treatment.

                Hospital performs all kinds of orthopedic surgeries including knee replacement, hip replacement, elbow replacement, shoulder replacement and spine surgeries as well as all kinds of trauma related surgeries. We also have facility for performing Arthroscopic procedures for carrying out joint surgeries through a small incision at the joint area. Our objective at orthopedic center is ‘Early Mobilization of patient with Minimal discomfort.",
                'image'=>'https://img.icons8.com/ios/50/737373/triangular-bandage.png',
            ],
            [
                'name' => 'Paediatrics',
                'des'=>"Madalasa Hospital is committed to providing the highest quality pediatric care to infants, children, and adolescents. Our team of experienced pediatricians and healthcare professionals is dedicated to providing compassionate, family-centered care that meets the unique needs of each child. At Madalasa Hospital, we offer a wide range of pediatric services, including routine check-ups, immunizations, and sick visits. Our goal is to help children grow and develop into healthy, happy adults by providing the care and support they need during their early years. We understand that visiting the doctor can be a stressful experience for both children and parents, which is why we strive to create a welcoming and comfortable environment. Our pediatricians and staff are trained to work with children of all ages and to make every visit as stress-free as possible. At Madālasā hospital we have well qualified & experienced child specialists to provide Medical & Vaccination service in Gurgaon. We are very concerned about the medical needs and requirements of young children and keep a complete track of their growth pattern and provide Vaccination Facility with the help of best Pediatricians on our panel. Computer generated messages are issued to parents from time to time as reminders to visit doctor for follow up and vaccination on due date. We have a fully equipped Neonatal Intensive Care Unit to provide skilled care to high risk new born babies. NICU is equipped with Open care incubators, Neonatal monitors, Servo-controlled warmers, Phototherapy machines, Infusion pumps etc. NICU is equipped to handle all varieties of neonatal emergencies e.g. Premature, RDS, Meconium aspiration syndrome, Neonatal seizures, Birth asphyxia etc.",
                'image'=>'https://img.icons8.com/ios/50/737373/breastfeeding.png',
            ],
            [
                'name' => 'ENT',
                'des'=>"Madalasa Hospital is proud to offer comprehensive ENT (Ear, Nose, and Throat) care for patients of all ages. Our team of experienced ENT specialists is committed to providing high-quality, personalized care that meets the unique needs of each patient. We understand that ear, nose, and throat issues can be disruptive and uncomfortable, which is why we strive to offer prompt and efficient diagnosis and treatment. Our ENT specialists use the latest diagnostic techniques and equipment to accurately diagnose and treat a wide range of conditions, from common ear infections to complex sinus and throat issues.

                At Madalasa Hospital, we offer a variety of ENT services, including hearing tests, allergy testing, endoscopic procedures, and surgical interventions. Our ENT specialists work closely with other medical professionals to ensure that our patients receive the most comprehensive and effective care possible.",
                'image'=>'https://img.icons8.com/ios/50/737373/hearing.png',
            ],
            [
                'name' => 'Physiotherapy',
                'des'=>"Madalasa Hospital is proud to offer high-quality physiotherapy services for patients of all ages. Our team of experienced physiotherapists is dedicated to helping patients recover from injuries, manage chronic conditions, and improve their overall physical health and well-being.

                Our physiotherapy services are designed to help patients regain strength, mobility, and flexibility after an injury or illness. We offer a variety of treatment options, including manual therapy, exercise programs, and other therapeutic techniques, to help our patients achieve their goals.
                
                At Madalasa Hospital, we believe in a patient-centered approach to physiotherapy. Our physiotherapists work closely with each patient to create a personalized treatment plan that meets their unique needs and goals. We also provide ongoing support and education to help our patients continue their recovery and achieve optimal physical health.
                
                In addition to traditional physiotherapy services, we also offer specialized programs for patients with chronic conditions such as arthritis, stroke, and Parkinson's disease. Our team of physiotherapists has extensive experience working with patients with these conditions and understands the unique challenges they face.
                
                If you are dealing with an injury or chronic condition, or simply want to improve your physical health, our team of physiotherapists is here to help. We are committed to providing compassionate, personalized care that helps our patients achieve their goals and live their best lives..",
                'image'=>'https://img.icons8.com/ios/50/737373/physical-therapy.png',
            ],
            [
                'name'=>'Dialysis',
                'des'=>"Madalasa Hospital is dedicated to providing comprehensive and compassionate care for patients with kidney failure. Our state-of-the-art dialysis center is staffed by experienced professionals who are committed to helping our patients achieve optimal health and well-being.

                Dialysis is a life-saving treatment for individuals with kidney failure, and we understand the importance of providing timely and effective treatment. Our team of dialysis professionals works closely with each patient to develop a personalized treatment plan that meets their unique needs and goals. We offer both hemodialysis and peritoneal dialysis treatments.
                
                Hemodialysis is a treatment that involves filtering the blood through an external machine. Our dialysis center is equipped with the latest technology to ensure that our patients receive the highest quality care possible. We offer both in-center hemodialysis and home hemodialysis options to meet the needs and preferences of our patients.
                
                Peritoneal dialysis is another option for patients with kidney failure. This treatment involves using the lining of the abdomen to filter the blood. Our team of dialysis professionals works closely with each patient to determine if peritoneal dialysis is the best option for them and provide support and education to ensure that our patients are comfortable with the treatment.
                
                At Madalasa Hospital, we understand that undergoing dialysis treatment can be stressful and overwhelming. That is why we strive to create a supportive and comfortable environment for our patients. We also offer education and support to our patients and their families to help them manage their condition and maintain their quality of life.
                
                If you or a loved one are experiencing kidney failure and require dialysis treatment, Madalasa Hospital is here to help. Our experienced team of dialysis professionals is dedicated to providing comprehensive, personalized care that meets the unique needs of each patient..",
                'image'=>'https://img.icons8.com/ios/50/737373/kidney.png',
            ]
        ];
        DB::table('departments')->insert($department);
    }
}
