@extends('backend.layouts.master')
@section('backendcontent')
    <div class="page-wrapper">
        <div class="content">
            <div class="page-header">
                <div class="row">
                    <div class="col-sm-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="doctors.html">SEO for Services </a></li>
                            <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                            <li class="breadcrumb-item active">Add Seo for Services</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="row"> 
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="{{route('services.seo.store')}}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-heading">
                                            <h4>Add services Details &nbsp;&nbsp; <a href="{{route('doctor.all')}}">View All services</a> </h4>
                                        </div>
                                        @if (session()->has('success'))
                                            <div class="alert alert-info">
                                                {{session('success')}}
                                            </div>
                                        @endif

                                        @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                    </div>

                                    <div class="col-12 col-md-12 col-xl-12">
                                        <div class="form-group local-forms">
                                            <label>Select Doctor <span class="login-danger">*</span></label>
                                            <select name="department_id" id="" class="form-control">
                                                <option value="">--Select--</option>
                                                @foreach ($allServices as $services)
                                                    <option value="{{ $services->id }}" {{ old('doctor_id') == $services->id ? 'selected' : '' }}>{{ $services->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                   
                                     
                                    <div class="col-12 col-sm-12">
                                        <div class="form-group local-forms">
                                            <label>Meta Title <span class="login-danger">*</span></label>
                                            <textarea class="form-control" rows="3" cols="30" name="metaTitle">{{old('metaTitle')}}</textarea>
                                        </div>
                                    </div>
                                    
                                    <div class="col-12 col-sm-12">
                                        <div class="form-group local-forms">
                                            <label>Meta description <span class="login-danger">*</span></label>
                                            <textarea class="form-control" rows="3" cols="30" name="metaDescription">{{old('metaDescription')}}</textarea>
                                        </div>
                                    </div>
                                     
                                    
                                    <div class="col-12">
                                        <div class="doctor-submit text-end">
                                            <button type="submit"
                                                class="btn btn-primary submit-form me-2">Submit</button>
                                            <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
         
    </div>
    <div id="delete_patient" class="modal fade delete-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="assets/img/sent.png" alt="" width="50" height="46">
                    <h3>Are you sure want to delete this ?</h3>
                    <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
