<form action="{{ route('appointments.store') }}" method="POST" class="contact-panel__form">
    @csrf
    @error('field_name')
        <div class="alert alert-danger">{{ $message }}</div>
    @enderror
 
    <div class="row">
        <div class="col-md-6 form-group">
            <label for="">Patient Name</label>
            <input type="text" class="form-control" name="patientName">
        </div>
        <div class="col-md-6 form-group">
            <label for="">Phone</label>
            <input type="text" class="form-control" name="patientPhone">
        </div>
        <div class="col-md-6 form-group">
            <label for="">Treatment</label>
            <select class="form-control" name="treatment">
                <option value="0">Choose Treatment</option>

                @foreach ($departments as $department)
                    <option value="{{ $department->name }}">{{ $department->name }}</option>
                @endforeach

            </select>
        </div>
        <div class="col-sm-6 col-md-6 col-lg-6">
            <div class="form-group">
                <label for="">Doctor</label>

                <select class="form-control" name="doctorName">
                    <option value="0">Choose Doctor</option>
                    @foreach ($doctors as $doctor)
                        <option value="{{ $doctor->doctorfname }}">{{ $doctor->doctorfname }} {{ $doctor->doctorlname }}
                        </option>
                    @endforeach

                </select>
            </div>
        </div>
       
        <div class="col-sm-6 col-md-6 col-lg-6">
            <div class="form-group">
                <label for="">Date</label>
                <input type="date" class="form-control" name="appointmentdate">
            </div>
        </div>
        <div class="col-sm-6 col-md-6 col-lg-6">
            <div class="form-group">
                <label for="">Time</label>
                <input type="time" class="form-control" name="appointmenttime">
            </div>
        </div>
        <div class="col-12">
            <button type="submit" class="btn btn__secondary btn__rounded btn__block btn__xhight mt-10">
                Request An Appointment<i class="icon-arrow-right"></i>
            </button>
        </div>
    </div>



</form>
{{-- <form class="contact-panel__form" method="post" action="https://7oroof.com/demos/medcity/assets/php/contact.php"
    id="contactForm">
    <div class="row">
        <div class="col-sm-12">
            <h4 class="contact-panel__title">Book An Appointment</h4>
            <p class="contact-panel__desc mb-30">Please feel welcome to contact our friendly
                reception staff
                with any general or medical enquiry. Our doctors will receive or return any
                urgent calls.
            </p>
        </div>
        <div class="col-sm-6 col-md-6 col-lg-6">
            <div class="form-group">
                <i class="icon-news form-group-icon"></i>
                <input type="text" class="form-control" placeholder="Name" id="contact-name" name="contact-name"
                    required>
            </div>
        </div><!-- /.col-lg-6 -->
        <div class="col-sm-6 col-md-6 col-lg-6">
            <div class="form-group">
                <i class="icon-email form-group-icon"></i>
                <input type="email" class="form-control" placeholder="Email" id="contact-email" name="contact-email"
                    required>
            </div>
        </div><!-- /.col-lg-6 -->
        <div class="col-sm-6 col-md-6 col-lg-6">
            <div class="form-group">
                <i class="icon-widget form-group-icon"></i>
                <select class="form-control">
                    <option value="0">Choose Treatment</option>

                    @foreach ($departments as $department)
                        <option value="2">{{ $department->name }}</option>
                    @endforeach

                </select>
            </div>
        </div><!-- /.col-lg-6 -->

        <div class="col-sm-6 col-md-6 col-lg-6">
            <div class="form-group">
                <i class="icon-widget form-group-icon"></i>
                <select class="form-control">
                    <option value="0">Choose Doctor</option>
                    @foreach ($doctors as $doctor)
                        <option value="{{ $doctor->doctorfname }}">{{ $doctor->doctorfname }} {{ $doctor->doctorlname }}
                        </option>
                    @endforeach

                </select>
            </div>
        </div>

        <div class="col-sm-4 col-md-4 col-lg-4">
            <div class="form-group">
                <i class="icon-phone form-group-icon"></i>
                <input type="text" class="form-control" placeholder="Phone" id="contact-Phone" name="contact-phone"
                    required>
            </div>
        </div><!-- /.col-lg-4 -->
        <div class="col-sm-4 col-md-4 col-lg-4">
            <div class="form-group form-group-date">
                <i class="icon-calendar form-group-icon"></i>
                <input type="date" class="form-control" id="contact-date" name="contact-date" required>
            </div>
        </div><!-- /.col-lg-4 -->
        <div class="col-sm-4 col-md-4 col-lg-4">
            <div class="form-group form-group-date">
                <i class="icon-clock form-group-icon"></i>
                <input type="time" class="form-control" id="contact-time" name="contact-time" required>
            </div>
        </div><!-- /.col-lg-4 -->
        <div class="col-12">
            <button type="submit" class="btn btn__secondary btn__rounded btn__block btn__xhight mt-10">
                <span>Book Appointment</span> <i class="icon-arrow-right"></i>
            </button>
            <div class="contact-result"></div>
        </div><!-- /.col-lg-12 -->
    </div><!-- /.row -->
</form>
 --}}
