@extends('frontend.layouts.master')
@section('content')
    <section>
        <style>
            /* Add this CSS to your project */
.table-responsive {
    overflow-x: auto;
}

.doctors-timetable {
    width: 100%;
    border-collapse: collapse;
    border-spacing: 0;
}

.doctors-timetable th,
.doctors-timetable td {
    padding: 8px;
    text-align: left;
    vertical-align: top;
    border-top: 1px solid #dee2e6;
}

.doctors-timetable thead th {
    background-color: #f8f9fa;
    color: #343a40;
    font-weight: 600;
}

.doctors-timetable tbody tr:nth-child(even) {
    background-color: #f2f2f2;
}

.doctors-timetable tbody td {
    vertical-align: middle;
}

.availability {
    display: flex;
    flex-wrap: wrap;
    gap: 4px;
}

.available,
.not-available {
    padding: 2px 6px;
    border-radius: 4px;
    font-weight: 600;
}

.available {
    background-color: #28a745;
    color: #fff;
}

.not-available {
    background-color: #dc3545;
    color: #fff;
}

/* Media Query for Responsive Table */
@media (max-width: 767px) {
    .doctors-timetable thead {
        display: none;
    }

    .doctors-timetable tbody td {
        display: block;
        padding: 8px;
        text-align: center;
    }

    .doctors-timetable tbody td::before {
        content: attr(data-label);
        font-weight: 600;
        display: block;
    }
}

        </style>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="table-responsive">
                        <table class="doctors-timetable w-100">
                            <thead>
                                <tr>
                                    <th>Doctor</th>
                                    <th>Specialty</th>
                                     
                                    <th>Morning Timings</th>
                                    <th>Evening Timings</th>
                                    <th>Days</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($doctorTimetables as $doctorId => $doctorData)
                                    <tr>
                                        <td>{{ $doctorData['name'] }}</td>
                                        <td>{{ $doctorData['specialty'] }}</td>
                                        
                                        <td>{{ $doctorData['morningTiming'] }}</td>
                                        <td>{{ $doctorData['eveningTiming'] }}</td>
                                        <td>
                                            <div class="availability">
                                                @foreach (['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'] as $day)
                                                    @if ($doctorId == 7 || ($doctorId != 7 && !in_array($day, [ 'Sunday'])))
                                                        <div class="available">{{ $day }}</div>
                                                    @else
                                                        <div class="not-available">{{ $day }}</div>
                                                    @endif
                                                @endforeach
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div><!-- /.col-12 -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </section><!-- /.Doctors Timetable -->
@endsection
