@extends('frontend.layouts.master')
@section('title', isset($doctorMetaTitle) ? $doctorMetaTitle->metaTitle : 'title')
@section('metaTitle', isset($doctorMetaTitle) ? $doctorMetaTitle->metaTitle : 'title')
@section('metaDescription', isset($doctorMetaTitle) ? $doctorMetaTitle->metaDescription : 'title')
@section('content')
    <section class="pt-120 pb-80">
        <div class="container">
            <div class="row"> 
                <div class="col-sm-12 col-md-12 col-lg-4">
                    <aside class="sidebar has-marign-right">
                        <div class="widget widget-member">
                            <div class="member mb-0" style="text-align: center">
                                <div class="member__img">
                                    <div class="image-container">
                                        <img src="{{ asset('doctor/images/' . $doctor->image) }}" alt="member img">
                                    </div>
                                </div><!-- /.member-img -->
                                <div class="member__info">
                                    <h5 class="member__name"><a
                                            href="#">{{ $doctor->doctorfname }}
                                            {{ $doctor->doctorlname }}</a></h5>
                                    <p class="member__job">{{ $doctor->specialty }}</p>
                                    <button data-toggle="modal" data-target="#exampleModal{{ $doctor->id }}"
                                        data-doctor-name="{{ $doctor->doctorfname }} {{ $doctor->doctorlname }}"
                                        data-specialty="{{ $doctor->specialty }}" data-name-input-id="doctorInput{{ $doctor->id }}"
                                        data-specialty-input-id="specialtyInput{{ $doctor->id }}"
                                        style="background-color: #1d2a4d; border-radius: 8px; color: white;">Book an Appointment<i
                                            class="icon-arrow-right"></i></button>
                                </div><!-- /.member-info -->
                            </div><!-- /.member -->
                        </div><!-- /.widget-member -->
                        {{--  <div class="widget widget-help bg-overlay bg-overlay-primary-gradient">
                            <div class="bg-img"><img src="assets/images/banners/5.jpg" alt="background"></div>
                            <div class="widget-content">
                                <div class="widget__icon">
                                    <i class="icon-call3"></i>
                                </div>
                                <h4 class="widget__title">Emergency Cases</h4>
                                <p class="widget__desc">Please feel welcome to contact our friendly reception staff with any
                                    general
                                    or medical enquiry call us.
                                </p>
                                <a href="tel:+919625066751" class="phone__number">
                                    <i class="icon-phone"></i> <span>+91 9625066751</span>
                                </a>
                                <a href="tel:+919319661010" class="phone__number">
                                    <i class="icon-phone"></i> <span>+91 9319661010</span>
                                </a>
                            </div><!-- /.widget-content -->
                        </div> --}}<!-- /.widget-help -->


                    </aside><!-- /.sidebar -->
                </div><!-- /.col-lg-4 -->
                <div class="col-sm-12 col-md-12 col-lg-8">
                    <div class="text-block mb-50">
                        <h5 class="text-block__title">About {{ $doctor->doctorfname }} {{ $doctor->doctorlname }}</h5>
                        <p class="text-block__desc mb-20 font-weight-bold color-secondary">
                            {{ substr($doctor->bio, 0, 205) }} <!-- Display the first 200 characters -->
                        </p>

                        <!-- Display the second part of the description, if it exists -->
                        @if (strlen($doctor->bio) > 205)
                            <p class="text-block__desc mb-20">
                                {{ substr($doctor->bio, 205) }} <!-- Display the remaining characters -->
                            </p>
                        @endif
                        <ul class="details-list list-unstyled mb-60">
                            <li>
                                <h5 class="details__title">Speciality</h5>
                                <div class="details__content">
                                    <p class="mb-0">{{ $doctor->specialty }} </p>
                                </div>
                            </li>


                            <li>
                                <h5 class="details__title">Location</h5>
                                <div class="details__content">
                                    <p class="mb-0">Behind Huda Market, Sector 46 Gurgaon Haryana &nbsp; <a
                                            href="https://maps.app.goo.gl/FdRWbuUSivKP7VYd9" target="_blank">Get
                                            Direction</a> </p>
                                </div>
                            </li>


                        </ul>


                    </div><!-- /.col-lg-8 -->
                </div><!-- /.row -->
            </div><!-- /.container -->
    </section>
    <div class="container mt-5">
        <h5>Our Doctors</h5>
        <div class="row">
            <!-- Repeat this doctor card section for each doctor -->
            @foreach ($doctors as $doctor)
                <div class="col-lg-2 col-md-3 col-sm-6 col-6 mb-4 doctor-card">
                    <div class="card h-100">
                        <img src="{{ asset('doctor/images/' . $doctor->image) }}" class="card-img-top img-fluid"
                            alt="{{ $doctor->doctorfname }} {{ $doctor->doctorlname }}">
                        <div class="card-body">
                            <a href="{{ route('doctor.show', ['id' => $doctor->id]) }}">
                                <h6 class="card-title">{{ $doctor->doctorfname }}
                                    {{ $doctor->doctorlname }}</h6>
                            </a>
                            <p class="card-text">{{ $doctor->specialty }}</p>
                            <!-- Add more information here -->
                        </div>
                        <button data-toggle="modal" data-target="#exampleModal{{ $doctor->id }}"
                            data-doctor-name="{{ $doctor->doctorfname }} {{ $doctor->doctorlname }}"
                            data-specialty="{{ $doctor->specialty }}" data-name-input-id="doctorInput{{ $doctor->id }}"
                            data-specialty-input-id="specialtyInput{{ $doctor->id }}"
                            style="background-color: #1d2a4d; border-radius: 8px; color: white;">Book an Appointment<i
                                class="icon-arrow-right"></i></button>
                    </div>
                </div>
                <!-- The modal -->
                <div class="modal fade" id="exampleModal{{ $doctor->id }}" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">Book An Appointment
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <form action="{{ route('appointments.store') }}" method="POST">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <label for="">Doctor Name</label>
                                            <input type="text" class="form-control" id="doctorInput{{ $doctor->id }}"
                                                name="doctorName" readonly>
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label for="">Treatment</label>
                                            <input type="text" class="form-control"
                                                id="specialtyInput{{ $doctor->id }}" name="treatment" readonly>
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label for="">Date</label>
                                            <input type="date" class="form-control"
                                                id="specialtyInput{{ $doctor->id }}" name="appointmentdate">
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label for="">Time</label>
                                            <input type="time" class="form-control"
                                                id="specialtyInput{{ $doctor->id }}" name="appointmenttime">
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label for="">Patient Name</label>
                                            <input type="text" class="form-control"
                                                id="specialtyInput{{ $doctor->id }}" name="patientName">
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label for="">Phone</label>
                                            <input type="text" class="form-control"
                                                id="specialtyInput{{ $doctor->id }}" name="patientPhone">
                                        </div>
                                        <div class="col-12">
                                            <button type="submit"
                                                class="btn btn__secondary btn__rounded btn__block btn__xhight mt-10">
                                                Request An Appointment<i class="icon-arrow-right"></i>
                                            </button>
                                        </div>
                                    </div>



                                </form>


                            </div>

                        </div>
                    </div>
                </div>
                <script>
                    // JavaScript function to update the modal input fields with the doctor's name and specialty
                    function updateModalInputs(doctorName, specialty, nameInputId, specialtyInputId) {
                        // Get the input elements by their IDs
                        var nameInput = document.getElementById(nameInputId);
                        var specialtyInput = document.getElementById(specialtyInputId);

                        // Update the input values
                        nameInput.value = doctorName;
                        specialtyInput.value = specialty;
                    }

                    // Attach a click event listener to the "Book an Appointment" button
                    var appointmentButtons = document.querySelectorAll('[data-toggle="modal"]');
                    appointmentButtons.forEach(function(button) {
                        button.addEventListener('click', function() {
                            var doctorName = this.getAttribute('data-doctor-name');
                            var specialty = this.getAttribute('data-specialty');
                            var nameInputId = this.getAttribute('data-name-input-id');
                            var specialtyInputId = this.getAttribute('data-specialty-input-id');
                            updateModalInputs(doctorName, specialty, nameInputId, specialtyInputId);
                        });
                    });
                </script>
            @endforeach
        </div>
    </div>
@endsection
