@extends('frontend.layouts.master')
@section('content')
    <section class="blog blog-single pt-0 pb-80">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-8">
                    <div class="post-item mb-0">
                        <div class="post__img">
                            <a href="#">
                                <img src="{{ asset('camp/images/' . $campdetails->campimage) }}" alt="post image"
                                    loading="lazy" style="width:700px; height:400px" />
                            </a>
                        </div>
                        <!-- /.post-img -->
                        <div class="post__body pb-0">
                            <div class="post__meta-cat">
                                <a href="#">Madalasa</a><a href="#">Hospital</a>
                            </div>
                            <!-- /.blog-meta-cat -->
                            <div class="post__meta d-flex align-items-center mb-20">
                                <span class="post__meta-date">{{ $campdetails->campdate }}</span>
                                 
                            </div>
                            <!-- /.blog-meta -->
                            <h1 class="post__title mb-30">
                                {{ $campdetails->name }}
                            </h1>
                            <div class="post__desc">
                                <p>
                                    {{$campdetails->des}}
                                </p>
                                
                            </div>
                            <!-- /.blog-desc -->
                        </div>
                    </div>
                  
                    
                   
                   
                    
                    
                </div>
                <!-- /.col-lg-8 -->
                <div class="col-sm-12 col-md-12 col-lg-4">
                    <aside class="sidebar">
                         
                        <!-- /.widget-search -->
                        <div class="widget widget-posts">
                            <h5 class="widget__title" style="color: white">Recent Blog</h5>
                            <div class="widget__content">
                                <!-- post item #1 -->
                                @foreach ($recent as $blog)
                                <div class="widget-post-item d-flex align-items-center">
                                    <div class="widget-post__img">
                                        <a href="#"><img src="{{asset('camp/images/'.$blog->campimage)}}" alt="thumb" /></a>
                                    </div>
                                    <!-- /.widget-post-img -->
                                    <div class="widget-post__content">
                                        <span class="widget-post__date">{{$blog->campdate}} &nbsp;{{$blog->camptime}}</span>
                                        <h4 class="widget-post__title" style="color: white">
                                            <a href="{{route('healthcamp.showFront.show',['id'=>$blog->id])}}" style="color: white">{{$blog->name}}</a>
                                        </h4>
                                    </div>
                                    <!-- /.widget-post-content -->
                                </div>
                                @endforeach
                               
                                 
                            </div>
                            <!-- /.widget-content -->
                        </div>
                        <!-- /.widget-posts -->
                        <div class="widget widget-categories">
                            <h5 class="widget__title" style="color: white">Services</h5>
                            <div class="widget-content">
                                <ul class="list-unstyled mb-0">
                                    @foreach ($departments as $department )
                                    <li>
                                        <a href="{{route('service.show',['id'=>$department->id])}}"><span class="cat-count"></span><span style="color: white">{{$department->name}}</span></a>
                                    </li>
                                    @endforeach
                                  
                                     
                                </ul>
                            </div>
                            <!-- /.widget-content -->
                        </div>
                        <!-- /.widget-categories -->
                         
                        <!-- /.widget-tags -->
                    </aside>
                    <!-- /.sidebar -->
                </div>
                <!-- /.col-lg-4 -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container -->
    </section>
    <!-- /.blog Single -->
@endsection
