@extends('frontend.layouts.master')
@section('content')
    <section id="content" class=" pb-80">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-8">
                    <div class="text-block mb-50">
                        <h5 class="text-block__title">Lab and X-Ray</h5>

                        <p class="text-block__desc mb-20" style="text-align: justify">
                            Madalasa Hospital is committed to providing high-quality laboratory and X-ray services for our patients. Our state-of-the-art diagnostic center is equipped with the latest technology and staffed by experienced professionals who are dedicated to providing accurate and timely results.

                            Our laboratory services include a wide range of diagnostic tests, including blood tests, urine tests, and other specialized tests. Our laboratory professionals work closely with our healthcare providers to ensure that our patients receive the appropriate tests and that results are delivered quickly and accurately.                        </p>
                        <p class="text-block__desc mb-20">
                            In addition to laboratory services, we also offer X-ray and other imaging services. Our diagnostic center is equipped with advanced imaging technology, including digital X-ray, ultrasound, and CT scans. Our team of radiologists and imaging professionals are experienced in performing and interpreting diagnostic tests to provide accurate and timely results.

At Madalasa Hospital, we understand that undergoing diagnostic tests can be stressful and overwhelming. That is why we strive to create a comfortable and supportive environment for our patients. Our team of healthcare professionals is available to answer any questions and provide guidance and support throughout the testing process.

We are also committed to using the latest technology and techniques to provide our patients with the most accurate and reliable results possible. Our laboratory and diagnostic center is accredited by the relevant regulatory bodies to ensure that our patients receive the highest quality care.

If you require laboratory or diagnostic services, Madalasa Hospital is here to help. Our team of experienced professionals is dedicated to providing compassionate, personalized care that meets the unique needs of each patient. We are committed to helping our patients achieve optimal health and well-being by providing accurate and timely diagnostic services.
                            
                        </p>
                    </div>
                    <div class="text-block mb-50">
                        <h5 class="text-block__title">Our Core Values</h5>
                        <p class="text-block__desc mb-20" style="text-align: justify">
                            At Madalasa Hospital, our commitment to excellence is driven by a set of core values that guide
                            every aspect of our healthcare services. These values define who we are and what you can expect
                            from us:
                        </p>
                    </div><!-- /.text-block -->
                    <div class="fancybox-layout1">
                        <div class="row">
                            <div class="col-md-6">
                                <!-- fancybox item #1 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-heart"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Patient-Centered Care</h4>
                                        <p class="fancybox__desc"> At Madalasa Hospital, you are the center of our care. We
                                            listen to your concerns, respect your choices</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #2 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-doctor"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Excellence</h4>
                                        <p class="fancybox__desc">We are committed to excellence in healthcare. Our hospital
                                            is equipped with state-of-the-art facilities</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #3 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-call3"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Emergency Help 24/7 </h4>
                                        <p class="fancybox__desc">Contact our reception staff with any medical enquiry any
                                            time for low
                                            cost coverage adults.</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #4 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-doctor"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Integrity </h4>
                                        <p class="fancybox__desc">All medical aspects practice for family, our reception
                                            staff with any
                                            medical enquiry any time.</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                        </div><!-- /.row -->
                    </div><!-- /.fancybox-layout1 -->
                  
                    <!-- /.text-block -->
                    <div id="accordion" class="mb-70">
                        <div class="accordion-item opened">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse3">
                                <a class="accordion__title" href="#">What Payment Methods Are Available?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse3" class="collapse show" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>With any financial product that you buy, it is important that you know you are
                                        getting the best
                                        advice from a reputable company as often</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse1">
                                <a class="accordion__title" href="#">Which Plan Is Right For Me?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse1" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>With any financial product that you buy, it is important that you know you are
                                        getting the best
                                        advice from a reputable company as often</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse2">
                                <a class="accordion__title" href="#">Do I have to commit to a contract?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse2" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>With any financial product that you buy, it is important that you know you are
                                        getting the best
                                        advice from a reputable company as often</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse4">
                                <a class="accordion__title" href="#">What if I pick the wrong plan?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse4" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>With any financial product that you buy, it is important that you know you are
                                        getting the best
                                        advice from a reputable company as often</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse5">
                                <a class="accordion__title" href="#">Any contracts or commitments?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse5" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>With any financial product that you buy, it is important that you know you are
                                        getting the best
                                        advice from a reputable company as often</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                    </div>

                </div><!-- /.col-lg-8 -->
                <div class="col-sm-12 col-md-12 col-lg-4">
                    <aside class="sidebar has-marign-left sticky-top">
                        <div class="widget widget-services">
                            <h5 class="widget__title">Medical Services</h5>
                            <div class="widget-content">
                                <ul class="list-unstyled mb-0">
                                    @foreach ($department as $services)
                                    <li><a href="{{route('service.show',['id'=>$services->id])}}"><span>{{$services->name}}</span><i
                                        class="icon-arrow-right"></i></a></li>
                                    @endforeach
                                </ul>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-services -->
                        <div class="widget widget-help bg-overlay bg-overlay-secondary-gradient">
                            <div class="bg-img"><img src="{{ asset('assetsimages/banners/5.jpg') }}" alt="background">
                            </div>
                            <div class="widget-content">
                                <div class="widget__icon">
                                    <i class="icon-call3"></i>
                                </div>
                                <h4 class="widget__title">Emergency Cases</h4>
                                <p class="widget__desc">Please feel welcome to contact our friendly reception staff with
                                    any general
                                    or medical enquiry call us.
                                </p>
                                <a href="tel:+201061245741" class="phone__number">
                                    <i class="icon-phone"></i> <span>01061245741</span>
                                </a>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-help -->
                        <div class="widget widget-schedule">
                            <div class="widget-content">
                                <div class="widget__icon">
                                    <i class="icon-charity2"></i>
                                </div>
                                <h4 class="widget__title">Opening Hours</h4>
                                <ul class="time__list list-unstyled mb-0">
                                    <li><span>24X7 OPEN</span></li>

                                </ul>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-schedule -->

                    </aside><!-- /.sidebar -->
                </div><!-- /.col-lg-4 -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </section>
@endsection
