@extends('frontend.layouts.master')
@section('title', $department->services->metaTitle ?? 'Default Title')
@section('metaTitle', $department->services->metaTitle ?? 'Default Meta Title')
@section('metaDescription', $department->services->metaDescription ?? 'Default Meta Description')
 
@section('content')
    <section id="content" class=" pb-80">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-8">
                    <div class="text-block mb-50">
                        <h5 class="text-block__title"> {{ $department->name }}</h5>

                        <p class="text-block__desc mb-20" style="text-align: justify">
                            @php
                                $description = $department->des;
                                $paragraphs = preg_split('/\n/', $description); // Split into paragraphs
                            @endphp

                            @foreach ($paragraphs as $paragraph)
                                <p>{{ $paragraph }}</p>
                            @endforeach
                        </p>
                        <p class="text-block__desc mb-20">

                        </p>
                    </div>
                    <div class="text-block mb-50">
                        <h5 class="text-block__title">Our Core Values</h5>
                        <p class="text-block__desc mb-20" style="text-align: justify">
                            At Madalasa Hospital, our commitment to excellence is driven by a set of core values that guide
                            every aspect of our healthcare services. These values define who we are and what you can expect
                            from us:
                        </p>
                    </div><!-- /.text-block -->
                    <div class="fancybox-layout1">
                        <div class="row">
                            <div class="col-md-6">
                                <!-- fancybox item #1 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-heart"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Patient-Centered Care</h4>
                                        <p class="fancybox__desc"> At Madalasa Hospital, you are the center of our care. We
                                            listen to your concerns, respect your choices</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #2 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-doctor"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Excellence</h4>
                                        <p class="fancybox__desc">We are committed to excellence in healthcare. Our hospital
                                            is equipped with state-of-the-art facilities</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #3 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-call3"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Emergency Help 24/7 </h4>
                                        <p class="fancybox__desc">Contact our reception staff with any medical enquiry any
                                            time for low
                                            cost coverage adults.</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #4 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-doctor"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Integrity </h4>
                                        <p class="fancybox__desc">All medical aspects practice for family, our reception
                                            staff with any
                                            medical enquiry any time.</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                        </div><!-- /.row -->
                    </div><!-- /.fancybox-layout1 -->
                    <div class="text-block mb-50">
                        <section class="team-layout2 pt-0 pb-30">
                            <div class="container mt-5">
                                <h5>Our Doctors</h5>
                                <div class="row">
                                    <!-- Repeat this doctor card section for each doctor -->
                                    @foreach ($department->doctors as $doctor)
                                        <div class="col-lg-3 col-md-4 col-sm-6 col-12 mb-4 mh-100">
                                            <div class="doctor-card">
                                                <div class="card h-100">
                                                    <img src="{{ asset('doctor/images/' . $doctor->image) }}"
                                                        class="card-img-top img-fluid"
                                                        alt="{{ $doctor->doctorfname }} {{ $doctor->doctorlname }}">
                                                    <div class="card-body">
                                                        <a href="{{ route('doctor.show', ['id' => $doctor->id]) }}">
                                                            <h6 class="card-title">{{ $doctor->doctorfname }}
                                                                {{ $doctor->doctorlname }}</h6>
                                                        </a>
                                                        <p class="card-text">{{ $doctor->specialty }}</p>
                                                        <!-- Add more information here -->
                                                    </div>
                                                    <button data-toggle="modal"
                                                        data-target="#exampleModal{{ $doctor->id }}"
                                                        data-doctor-name="{{ $doctor->doctorfname }} {{ $doctor->doctorlname }}"
                                                        data-specialty="{{ $doctor->specialty }}"
                                                        data-name-input-id="doctorInput{{ $doctor->id }}"
                                                        data-specialty-input-id="specialtyInput{{ $doctor->id }}"
                                                        style="background-color: #1d2a4d; border-radius: 8px; color: white;">Book
                                                        an Appointment<i class="icon-arrow-right"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- The modal -->
                                        <div class="modal fade" id="exampleModal{{ $doctor->id }}" tabindex="-1"
                                            role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">Book An Appointment
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <form action="{{ route('appointments.store') }}" method="POST">
                                                            @csrf
                                                            <div class="row">
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Doctor Name</label>
                                                                    <input type="text" class="form-control"
                                                                        id="doctorInput{{ $doctor->id }}"
                                                                        name="doctorName" readonly>
                                                                </div>
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Treatment</label>
                                                                    <input type="text" class="form-control"
                                                                        id="specialtyInput{{ $doctor->id }}"
                                                                        name="treatment" readonly>
                                                                </div>
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Date</label>
                                                                    <input type="date" class="form-control"
                                                                        id="specialtyInput{{ $doctor->id }}"
                                                                        name="appointmentdate">
                                                                </div>
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Time</label>
                                                                    <input type="time" class="form-control"
                                                                        id="specialtyInput{{ $doctor->id }}"
                                                                        name="appointmenttime">
                                                                </div>
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Patient Name</label>
                                                                    <input type="text" class="form-control"
                                                                        id="specialtyInput{{ $doctor->id }}"
                                                                        name="patientName">
                                                                </div>
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Phone</label>
                                                                    <input type="text" class="form-control"
                                                                        id="specialtyInput{{ $doctor->id }}"
                                                                        name="patientPhone">
                                                                </div>
                                                                <div class="col-12">
                                                                    <button type="submit"
                                                                        class="btn btn__secondary btn__rounded btn__block btn__xhight mt-10">
                                                                        Request An Appointment<i
                                                                            class="icon-arrow-right"></i>
                                                                    </button>
                                                                </div>
                                                            </div>



                                                        </form>


                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                        <script>
                                            // JavaScript function to update the modal input fields with the doctor's name and specialty
                                            function updateModalInputs(doctorName, specialty, nameInputId, specialtyInputId) {
                                                // Get the input elements by their IDs
                                                var nameInput = document.getElementById(nameInputId);
                                                var specialtyInput = document.getElementById(specialtyInputId);

                                                 nameInput.value = doctorName;
                                                specialtyInput.value = specialty;
                                            }

                                             var appointmentButtons = document.querySelectorAll('[data-toggle="modal"]');
                                            appointmentButtons.forEach(function(button) {
                                                button.addEventListener('click', function() {
                                                    var doctorName = this.getAttribute('data-doctor-name');
                                                    var specialty = this.getAttribute('data-specialty');
                                                    var nameInputId = this.getAttribute('data-name-input-id');
                                                    var specialtyInputId = this.getAttribute('data-specialty-input-id');
                                                    updateModalInputs(doctorName, specialty, nameInputId, specialtyInputId);
                                                });
                                            });
                                        </script>
                                    @endforeach
                                </div>
                            </div>


                        </section><!-- /.Team -->
                    </div>

                    <!-- /.text-block -->
                    <div id="accordion" class="mb-70">
                        <div class="accordion-item opened">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse3">
                                <a class="accordion__title" href="#">What are the visiting hours at Madalasa
                                    Hospital?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse3" class="collapse show" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p> Our hospital is open 24/7, and visitors are welcome at any time. However, we do
                                        recommend checking with specific departments or patient wards for any restrictions
                                        or guidelines related to visiting patients.</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse1">
                                <a class="accordion__title" href="#">Do you accept insurance plans, and which
                                    ones?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse1" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>Yes, we accept a variety of insurance plans. To ensure your insurance is accepted, we
                                        recommend contacting our billing department or checking our website for a list of
                                        accepted insurance providers. Our team is also available to assist you with
                                        insurance-related queries. Call Us: - <a href="tel:+919625066751">+91
                                            9625066751</a> &nbsp; &nbsp;<a href="tel:+9193196 61010">+91 93196 61010</a>
                                        &nbsp; &nbsp;<a href="{{ route('contact.show') }}">Get in touch</a></p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse2">
                                <a class="accordion__title" href="#">How can I reach Madalasa Hospital from the
                                    nearest public transportation hub?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse2" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>Madalasa Hospital is conveniently located behind Huda Market in Sector 46, Gurgaon.
                                        You can easily reach us by taking a local bus, auto-rickshaw, or cab from the
                                        nearest metro station or bus stop. Our hospital's address is <a
                                            href="https://maps.app.goo.gl/FdRWbuUSivKP7VYd9"> Get Direction</a>, making it
                                        accessible for patients and visitors.</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse4">
                                <a class="accordion__title" href="#">What specialized treatments or procedures are
                                    available at Madalasa Hospital?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse4" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p> Madalasa Hospital offers a wide range of specialized treatments and procedures,
                                        including advanced surgeries, diagnostic services, and specialized clinics for
                                        specific medical conditions. To learn more about our specialized services, you can
                                        visit our <a href="{{ route('index') }}">"Services"</a></p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->

                    </div>

                </div><!-- /.col-lg-8 -->
                <div class="col-sm-12 col-md-12 col-lg-4">
                    <aside class="sidebar has-marign-left sticky-top">
                        <div class="widget widget-services">
                            <h5 class="widget__title" style="color: white">Medical Services</h5>  
                            <div class="widget-content">
                                <ul class="list-unstyled mb-0">
                                        @foreach ($departments as $department )
                                            
                                        
                                    <li><a href="{{route('service.show',['id'=>$department->id])}}"><span>{{$department->name}}</span>
                                            <i class="icon-arrow-right"></i></a></li>
                                            @endforeach
                                </ul>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-services -->
                        <div class="widget widget-help bg-overlay bg-overlay-secondary-gradient">
                            <div class="bg-img"><img src="{{ asset('assetsimages/banners/5.jpg') }}" alt="background">
                            </div>
                            <div class="widget-content">
                                <div class="widget__icon">
                                    <i class="icon-call3"></i>
                                </div>
                                <h4 class="widget__title">Emergency Cases</h4>
                                <p class="widget__desc">Please feel welcome to contact our friendly reception staff with
                                    any general
                                    or medical enquiry call us.
                                </p>
                                <a href="tel:+919319661010" class="phone__number">
                                    <i class="icon-phone"></i> <span><a href="tel:+919319661010" style="color: white">+91 9319661010</a></span>
                                </a>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-help -->
                        <div class="widget widget-schedule">
                            <div class="widget-content">
                                <div class="widget__icon">
                                    <i class="icon-charity2"></i>
                                </div>
                                <h4 class="widget__title">Opening Hours</h4>
                                <ul class="time__list list-unstyled mb-0">
                                    <li><span>24X7 OPEN</span></li>

                                </ul>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-schedule -->

                    </aside><!-- /.sidebar -->
                </div><!-- /.col-lg-4 -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </section>
@endsection
