
<?php $__env->startSection('content'); ?>
    <section id="content" class=" pb-80">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-8">
                    <div class="text-block mb-50">
                        <h5 class="text-block__title"> Dietitian</h5>

                        <p class="text-block__desc mb-20" style="text-align: justify">
                            At Madalasa dietitian provides expert nutritional guidance and support to patients. They assess dietary needs, develop personalized meal plans, and educate individuals on healthy eating habits. Dietitians work closely with medical teams to manage specific conditions, such as diabetes, heart disease, and food allergies. Their goal is to optimize patients' health through proper nutrition and diet management.
                        
                    </div>
                    <div class="text-block mb-50">
                        <section class="team-layout2 pt-0 pb-30">
                            <div class="container mt-5">
                                <h5>Our Doctors</h5>
                                <div class="row">
                                    <!-- Repeat this doctor card section for each doctor -->
                                    <div class="col-lg-3 col-md-4 col-sm-6 col-12 mb-4 mh-100">
                                        <div class="doctor-card">
                                            <div class="card h-100">
                                                <?php if($doctor): ?>
                                                    <img src="<?php echo e(asset('doctor/images/' . $doctor->image)); ?>"
                                                        class="card-img-top img-fluid"
                                                        alt="<?php echo e($doctor->doctorfname); ?> <?php echo e($doctor->doctorlname); ?>">
                                                    <div class="card-body">
                                                        <a href="<?php echo e(route('doctor.show', ['id' => $doctor->id])); ?>">
                                                            <h6 class="card-title"><?php echo e($doctor->doctorfname); ?> <?php echo e($doctor->doctorlname); ?></h6>
                                                        </a>
                                                        <p class="card-text"><?php echo e($doctor->specialty); ?></p>
                                                        <!-- Add more information here -->
                                                    </div>
                                                    <button data-toggle="modal"
                                                        data-target="#exampleModal<?php echo e($doctor->id); ?>"
                                                        data-doctor-name="<?php echo e($doctor->doctorfname); ?> <?php echo e($doctor->doctorlname); ?>"
                                                        data-specialty="<?php echo e($doctor->specialty); ?>"
                                                        data-name-input-id="doctorInput<?php echo e($doctor->id); ?>"
                                                        data-specialty-input-id="specialtyInput<?php echo e($doctor->id); ?>"
                                                        style="background-color: #1d2a4d; border-radius: 8px; color: white;">Book
                                                        an Appointment<i class="icon-arrow-right"></i></button>
                                                <?php else: ?>
                                                    <p>No doctor found with the name Deepak Sharma</p>
                                                <?php endif; ?>
                                                   <!-- The modal -->
                                        <div class="modal fade" id="exampleModal<?php echo e($doctor->id); ?>" tabindex="-1"
                                            role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">Book An Appointment
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <form action="<?php echo e(route('appointments.store')); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <div class="row">
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Doctor Name</label>
                                                                    <input type="text" class="form-control"
                                                                        id="doctorInput<?php echo e($doctor->id); ?>"
                                                                        name="doctorName" readonly>
                                                                </div>
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Treatment</label>
                                                                    <input type="text" class="form-control"
                                                                        id="specialtyInput<?php echo e($doctor->id); ?>"
                                                                        name="treatment" readonly>
                                                                </div>
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Date</label>
                                                                    <input type="date" class="form-control"
                                                                        id="specialtyInput<?php echo e($doctor->id); ?>"
                                                                        name="appointmentdate">
                                                                </div>
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Time</label>
                                                                    <input type="time" class="form-control"
                                                                        id="specialtyInput<?php echo e($doctor->id); ?>"
                                                                        name="appointmenttime">
                                                                </div>
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Patient Name</label>
                                                                    <input type="text" class="form-control"
                                                                        id="specialtyInput<?php echo e($doctor->id); ?>"
                                                                        name="patientName">
                                                                </div>
                                                                <div class="col-md-6 form-group">
                                                                    <label for="">Phone</label>
                                                                    <input type="text" class="form-control"
                                                                        id="specialtyInput<?php echo e($doctor->id); ?>"
                                                                        name="patientPhone">
                                                                </div>
                                                                <div class="col-12">
                                                                    <button type="submit"
                                                                        class="btn btn__secondary btn__rounded btn__block btn__xhight mt-10">
                                                                        Request An Appointment<i
                                                                            class="icon-arrow-right"></i>
                                                                    </button>
                                                                </div>
                                                            </div>



                                                        </form>


                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                        <script>
                                            // JavaScript function to update the modal input fields with the doctor's name and specialty
                                            function updateModalInputs(doctorName, specialty, nameInputId, specialtyInputId) {
                                                // Get the input elements by their IDs
                                                var nameInput = document.getElementById(nameInputId);
                                                var specialtyInput = document.getElementById(specialtyInputId);

                                                // Update the input values
                                                nameInput.value = doctorName;
                                                specialtyInput.value = specialty;
                                            }

                                            // Attach a click event listener to the "Book an Appointment" button
                                            var appointmentButtons = document.querySelectorAll('[data-toggle="modal"]');
                                            appointmentButtons.forEach(function(button) {
                                                button.addEventListener('click', function() {
                                                    var doctorName = this.getAttribute('data-doctor-name');
                                                    var specialty = this.getAttribute('data-specialty');
                                                    var nameInputId = this.getAttribute('data-name-input-id');
                                                    var specialtyInputId = this.getAttribute('data-specialty-input-id');
                                                    updateModalInputs(doctorName, specialty, nameInputId, specialtyInputId);
                                                });
                                            });
                                        </script>
                                            </div>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                            
                            
                        </section><!-- /.Team -->
                    </div>
                    <div class="text-block mb-50">
                        <h5 class="text-block__title">Our Core Values</h5>
                        <p class="text-block__desc mb-20" style="text-align: justify">
                            At Madalasa Hospital, our commitment to excellence is driven by a set of core values that guide
                            every aspect of our healthcare services. These values define who we are and what you can expect
                            from us:
                        </p>
                    </div><!-- /.text-block -->
                    <div class="fancybox-layout1">
                        <div class="row">
                            <div class="col-md-6">
                                <!-- fancybox item #1 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-heart"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Patient-Centered Care</h4>
                                        <p class="fancybox__desc"> At Madalasa Hospital, you are the center of our care. We
                                            listen to your concerns, respect your choices</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #2 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-doctor"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Excellence</h4>
                                        <p class="fancybox__desc">We are committed to excellence in healthcare. Our hospital
                                            is equipped with state-of-the-art facilities</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #3 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-call3"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Emergency Help 24/7 </h4>
                                        <p class="fancybox__desc">Contact our reception staff with any medical enquiry any
                                            time for low
                                            cost coverage adults.</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #4 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-doctor"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Integrity </h4>
                                        <p class="fancybox__desc">All medical aspects practice for family, our reception
                                            staff with any
                                            medical enquiry any time.</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                        </div><!-- /.row -->
                    </div><!-- /.fancybox-layout1 -->
                  
                    <!-- /.text-block -->
                    <div id="accordion" class="mb-70">
                        <div class="accordion-item opened">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse3">
                                <a class="accordion__title" href="#">What Payment Methods Are Available?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse3" class="collapse show" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>With any financial product that you buy, it is important that you know you are
                                        getting the best
                                        advice from a reputable company as often</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse1">
                                <a class="accordion__title" href="#">Which Plan Is Right For Me?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse1" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>With any financial product that you buy, it is important that you know you are
                                        getting the best
                                        advice from a reputable company as often</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse2">
                                <a class="accordion__title" href="#">Do I have to commit to a contract?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse2" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>With any financial product that you buy, it is important that you know you are
                                        getting the best
                                        advice from a reputable company as often</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse4">
                                <a class="accordion__title" href="#">What if I pick the wrong plan?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse4" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>With any financial product that you buy, it is important that you know you are
                                        getting the best
                                        advice from a reputable company as often</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse5">
                                <a class="accordion__title" href="#">Any contracts or commitments?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse5" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>With any financial product that you buy, it is important that you know you are
                                        getting the best
                                        advice from a reputable company as often</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                    </div>

                </div><!-- /.col-lg-8 -->
                <div class="col-sm-12 col-md-12 col-lg-4">
                    <aside class="sidebar has-marign-left sticky-top">
                        <div class="widget widget-services">
                            <h5 class="widget__title" style="color: white">Medical Services</h5>
                            <div class="widget-content">
                                <ul class="list-unstyled mb-0">
                                    <?php $__currentLoopData = $department; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $services): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e(route('service.show',['id'=>$services->id])); ?>"><span><?php echo e($services->name); ?></span><i
                                        class="icon-arrow-right"></i></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                   
                                     
                                </ul>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-services -->
                        <div class="widget widget-help bg-overlay bg-overlay-secondary-gradient">
                            <div class="bg-img"><img src="<?php echo e(asset('assetsimages/banners/5.jpg')); ?>" alt="background">
                            </div>
                            <div class="widget-content">
                                <div class="widget__icon">
                                    <i class="icon-call3"></i>
                                </div>
                                <h4 class="widget__title">Emergency Cases</h4>
                                <p class="widget__desc">Please feel welcome to contact our friendly reception staff with
                                    any general
                                    or medical enquiry call us.
                                </p>
                                <a href="tel:+201061245741" class="phone__number">
                                    <i class="icon-phone"></i> <span>01061245741</span>
                                </a>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-help -->
                        <div class="widget widget-schedule">
                            <div class="widget-content">
                                <div class="widget__icon">
                                    <i class="icon-charity2"></i>
                                </div>
                                <h4 class="widget__title">Opening Hours</h4>
                                <ul class="time__list list-unstyled mb-0">
                                    <li><span>24X7 OPEN</span></li>

                                </ul>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-schedule -->

                    </aside><!-- /.sidebar -->
                </div><!-- /.col-lg-4 -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\madalasa hospital\new version code\newSeptember\resources\views/frontend/pages/services/dietians.blade.php ENDPATH**/ ?>