
<?php $__env->startSection('metaTitle' ,'Best Multispeciality Hospital in Sector 46 Gurgaon - Madalasa Hospital'); ?>
<?php $__env->startSection('metaDescription', 'At Madalasa Hospital, our mission is to provide high-quality care with compassion and respect. We aim to be your first and best choice for family healthcare'); ?>
<?php $__env->startSection('content'); ?>


 

    <div class="wrapper">
        <div class="preloader">
            <div class="loading"><span></span><span></span><span></span><span></span></div>
        </div> 
        <section class="slider">
            <div class="slick-carousel m-slides-0"
                data-slick='{"slidesToShow": 1, "arrows": true, "dots": false, "speed": 700,"fade": true,"cssEase": "linear"}'>
                <div class="slide-item align-v-h">
                    <style>
                        @media (max-width: 767px) {
                            .img-desktop {
                                display: none !important;
                            }
                        }

                        @media (min-width: 768px) {
                            .img-mobile {
                                display: none !important;
                            }
                        }
                    </style>
                   <div class="bg-img">
                    <img src="<?php echo e(asset('assets/images/sliders/s1.gif')); ?>" alt="slide img"  >
                    <img src="<?php echo e(asset('assets/images/sliders/s22.jpg')); ?>" alt="slide img" >
                </div>
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-7">
                                <div class="slide__content">
                                    <h2 class="slide__title">Providing Best Health Care</h2>
                                    <p class="slide__desc">The health and well-being of our patients and their health care
                                        team will
                                        always be our priority, so we follow the best practices for cleanliness.</p>
                                    <ul class="features-list list-unstyled mb-0 d-flex flex-wrap">
                                        <!-- feature item #1 -->
                                        <li class="feature-item">
                                            <div class="feature__icon">
                                                <i class="icon-heart"></i>
                                            </div>
                                            <h2 class="feature__title">Examination</h2>
                                        </li> 
                                        <li class="feature-item">
                                            <div class="feature__icon">
                                                <i class="icon-medicine"></i>
                                            </div>
                                            <h2 class="feature__title">Prescription</h2>
                                        </li> 
                                        <li class="feature-item">
                                            <div class="feature__icon">
                                                <i class="icon-heart2"></i>
                                            </div>
                                            <h2 class="feature__title">Cardiogram</h2>
                                        </li> 
                                        <li class="feature-item">
                                            <div class="feature__icon">
                                                <i class="icon-blood-test"></i>
                                            </div>
                                            <h2 class="feature__title">Blood Pressure</h2>
                                        </li><!-- /.feature-item-->
                                    </ul><!-- /.features-list -->
                                </div><!-- /.slide-content -->
                            </div><!-- /.col-xl-7 -->
                        </div><!-- /.row -->
                    </div><!-- /.container -->
                </div><!-- /.slide-item -->

                <div class="slide-item align-v-h">
                    <div class="bg-img"><img src="<?php echo e(asset('assets/images/sliders/2.jpg')); ?>" alt="slide img"></div>
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-7">
                                <div class="slide__content">
                                    <h2 class="slide__title">All Aspects Of Medical Practice</h2>
                                    <p class="slide__desc">The health and well-being of our patients and their health care
                                        team will always be our priority, so we follow the best practices for cleanliness.</p>
                                    <ul class="features-list list-unstyled mb-0 d-flex flex-wrap">
                                        <!-- feature item #1 -->
                                        <li class="feature-item">
                                            <div class="feature__icon">
                                                <i class="icon-heart"></i>
                                            </div>
                                            <h2 class="feature__title">Examination</h2>
                                        </li><!-- /.feature-item-->
                                        <!-- feature item #2 -->
                                        <li class="feature-item">
                                            <div class="feature__icon">
                                                <i class="icon-medicine"></i>
                                            </div>
                                            <h2 class="feature__title">Prescription </h2>
                                        </li><!-- /.feature-item-->
                                        <!-- feature item #3 -->
                                        <li class="feature-item">
                                            <div class="feature__icon">
                                                <i class="icon-heart2"></i>
                                            </div>
                                            <h2 class="feature__title">Cardiogram</h2>
                                        </li><!-- /.feature-item-->
                                        <!-- feature item #4 -->
                                        <li class="feature-item">
                                            <div class="feature__icon">
                                                <i class="icon-blood-test"></i>
                                            </div>
                                            <h2 class="feature__title">Blood Pressure</h2>
                                        </li><!-- /.feature-item-->
                                    </ul><!-- /.features-list -->
                                </div><!-- /.slide-content -->
                            </div><!-- /.col-xl-7 -->
                        </div><!-- /.row -->
                    </div><!-- /.container -->
                </div><!-- /.slide-item -->
            </div><!-- /.carousel -->
        </section><!-- /.slider -->

        <!-- ============================
                                                                           contact info
                                                                       ============================== -->
        <section class="contact-info py-0">
            <div class="container">
                <div class="row row-no-gutter boxes-wrapper">
                    <div class="col-sm-12 col-md-4">
                        <div class="contact-box d-flex">
                            <div class="contact__icon">
                                <i class="icon-call3"></i>
                            </div><!-- /.contact__icon -->
                            <div class="contact__content">
                                <h2 class="contact__title">Emergency Cases</h2>
                                <p class="contact__desc">Please feel free to contact our friendly reception staff with any
                                    general or
                                    medical enquiry.</p>
                                <a href="tel:+919625066751" class="phone__number">
                                    <i class="icon-phone"></i> <span>+91 93196 61010</span>
                                </a>
                            </div><!-- /.contact__content -->
                        </div><!-- /.contact-box -->
                    </div><!-- /.col-md-4 -->
                    <div class="col-sm-12 col-md-4">
                        <div class="contact-box d-flex">
                            <div class="contact__icon">
                                <i class="icon-health-report"></i>
                            </div><!-- /.contact__icon -->
                            <div class="contact__content">
                                <h2 class="contact__title">Doctors Timetable</h2>
                                <p class="contact__desc">Qualified doctors available six days a week, view our timetable to
                                    make an
                                    appointment.</p>
                                <a href="<?php echo e(route('doctorTime.show')); ?>" class="btn btn__white btn__outlined btn__rounded">
                                    <span>View Timetable</span><i class="icon-arrow-right"></i>
                                </a>
                            </div><!-- /.contact__content -->
                        </div><!-- /.contact-box -->
                    </div><!-- /.col-md-4 -->
                    <div class="col-sm-12 col-md-4">
                        <div class="contact-box d-flex">
                            <div class="contact__icon">
                                <i class="icon-heart2"></i>
                            </div><!-- /.contact__icon -->
                            <div class="contact__content">
                                <h2 class="contact__title">24X7 Services</h2>
                                <ul class="time__list list-unstyled mb-0">
                                    <li><i class="icon-first-aid-kit"></i>
                                        <span>ICU & NICU</span><span> &nbsp;- 24X7 Available</span>
                                    </li>
                                    <li><i class="icon-ambulance"></i><span>Ambulance</span><span> &nbsp; - 24X7 Available
                                        </span></li>
                                    <li><i class="icon-drugs"></i><span>Pharmacy</span><span> - 24X7 Available</span></li>
                                </ul>
                            </div><!-- /.contact__content -->
                        </div><!-- /.contact-box -->
                    </div><!-- /.col-md-4 -->
                </div><!-- /.row -->
            </div><!-- /.container -->
        </section><!-- /.contact-info -->

        <div class="container">
            <div class="row align-items-center">
                <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
                    <div class="slide__content">
                        <h5 class="slide__title">Our Services</h5>
                        <hr>
                        <ul class="features-list list-unstyled mb-0 d-flex flex-wrap">
                            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="feature-item">
                                    <a href="<?php echo e(route('service.show', ['id' => $department->name])); ?>">  <div class="feature__icon">
                                        <?php if($department->image): ?>
                                           <img src="<?php echo e($department->image); ?>" alt="Image Alt Text">
                                        <?php else: ?>
                                            <p>No icon available for this department.</p>
                                        <?php endif; ?>
                                    </div></a>
                                    <a href="<?php echo e(route('service.show', ['id' => $department->id])); ?>">
                                        <h2 class="feature__title"><?php echo e($department->name); ?></h2>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <li class="feature-item">
                                <div class="feature__icon">
                                   <a href="https://madalasahospital.com/service/icu"> <img width="50" height="50"
                                        src="https://img.icons8.com/ios/50/737373/hospital-room--v1.png"
                                        alt="hospital-room--v1" /></a>
                                </div>
                               <a href="https://madalasahospital.com/service/icu"> <h2 class="feature__title">ICU & NICU</h2></a>
                            </li>
                            <li class="feature-item">
                                <div class="feature__icon">
                                   <a href="https://madalasahospital.com/service/icu">   <img width="64" height="64" src="https://img.icons8.com/external-ddara-lineal-ddara/64/000000/external-dietitian-vegan-ddara-lineal-ddara.png" alt="external-dietitian-vegan-ddara-lineal-ddara"/></a>
                                </div>
                               <a href="https://madalasahospital.com/service/icu"> <h2 class="feature__title">Dietitian</h2></a>
                            </li>
                            <li class="feature-item">
                                <div class="feature__icon">
                                   <a href="https://madalasahospital.com/service/lab-xray"> <img width="50" height="50"
                                        src="https://img.icons8.com/ios/50/737373/body-scan.png" alt="body-scan" /></a>
                                </div>
                                <a href="https://madalasahospital.com/service/lab-xray"><h2 class="feature__title">X-Ray</h2></a>
                            </li>
                            <li class="feature-item">
                                <a href="https://madalasahospital.com/service/lab-xray"> <div class="feature__icon">
                                    <i class="icon-blood-test"></i>
                                </div>
                                </a>
                                 <a href="https://madalasahospital.com/service/lab-xray"><h2 class="feature__title">Lab</h2></a>
                            </li>

                            <!-- /.feature-item-->
                        </ul><!-- /.features-list -->
                    </div><!-- /.slide-content -->
                </div><!-- /.col-xl-7 -->
            </div><!-- /.row -->
        </div><!-- /.container -->
        <style>
            /* Custom CSS for phone devices */
            @media (max-width: 767px) {
                .doctor-card {
                    flex-basis: calc(50% - 5px);
                    /* Split into two columns */
                    margin-right: 5px;
                }

                .doctor-card:last-child {
                    margin-right: 0;
                }
            }
        </style>

        <div class="container mt-5">
            <h5>Our Doctors</h5>
            <div class="row">
                <!-- Repeat this doctor card section for each doctor -->
                <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-2 col-md-3 col-sm-6 col-6 mb-4 doctor-card">
                        <div class="card h-100">
                            <img src="<?php echo e(asset('doctor/images/' . $doctor->image)); ?>" class="card-img-top img-fluid"
                                alt="<?php echo e($doctor->doctorfname); ?> <?php echo e($doctor->doctorlname); ?>">
                            <div class="card-body">
                                <a href="<?php echo e(route('doctor.show', ['id' => $doctor->id])); ?>">
                                    <h6 class="card-title"><?php echo e($doctor->doctorfname); ?> <?php echo e($doctor->doctorlname); ?></h6>
                                </a>
                                <p class="card-text"><?php echo e($doctor->specialty); ?></p>
                                <!-- Add more information here -->
                            </div>
                            <button data-toggle="modal" data-target="#exampleModal<?php echo e($doctor->id); ?>"
                                data-doctor-name="<?php echo e($doctor->doctorfname); ?> <?php echo e($doctor->doctorlname); ?>"
                                data-specialty="<?php echo e($doctor->specialty); ?>"
                                data-name-input-id="doctorInput<?php echo e($doctor->id); ?>"
                                data-specialty-input-id="specialtyInput<?php echo e($doctor->id); ?>"
                                style="background-color: #1d2a4d; border-radius: 8px; color: white;">Book an Appointment<i
                                    class="icon-arrow-right"></i></button>



                        </div>
                    </div>
                    <!-- The modal -->
                    <div class="modal fade" id="exampleModal<?php echo e($doctor->id); ?>" tabindex="-1" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">Book An Appointment
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="<?php echo e(route('appointments.store')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-md-6 form-group">
                                                <label for="">Doctor Name</label>
                                                <input type="text" class="form-control"
                                                    id="doctorInput<?php echo e($doctor->id); ?>" name="doctorName" readonly>
                                            </div>
                                            <div class="col-md-6 form-group">
                                                <label for="">Treatment</label>
                                                <input type="text" class="form-control"
                                                    id="specialtyInput<?php echo e($doctor->id); ?>" name="treatment" readonly>
                                            </div>
                                            <div class="col-md-6 form-group">
                                                <label for="">Date</label>
                                                <input type="date" class="form-control"
                                                    id="specialtyInput<?php echo e($doctor->id); ?>" name="appointmentdate">
                                            </div>
                                            <div class="col-md-6 form-group">
                                                <label for="">Time</label>
                                                <input type="time" class="form-control"
                                                    id="specialtyInput<?php echo e($doctor->id); ?>" name="appointmenttime">
                                            </div>
                                            <div class="col-md-6 form-group">
                                                <label for="">Patient Name</label>
                                                <input type="text" class="form-control"
                                                    id="specialtyInput<?php echo e($doctor->id); ?>" name="patientName">
                                            </div>
                                            <div class="col-md-6 form-group">
                                                <label for="">Phone</label>
                                                <input type="text" class="form-control"
                                                    id="specialtyInput<?php echo e($doctor->id); ?>" name="patientPhone">
                                            </div>
                                            <div class="col-12">
                                                <button type="submit"
                                                    class="btn btn__secondary btn__rounded btn__block btn__xhight mt-10">
                                                    Request An Appointment<i class="icon-arrow-right"></i>
                                                </button>
                                            </div>
                                        </div>



                                    </form>


                                </div>

                            </div>
                        </div>
                    </div>
                    <script>
                        // JavaScript function to update the modal input fields with the doctor's name and specialty
                        function updateModalInputs(doctorName, specialty, nameInputId, specialtyInputId) {
                            // Get the input elements by their IDs
                            var nameInput = document.getElementById(nameInputId);
                            var specialtyInput = document.getElementById(specialtyInputId);

                            // Update the input values
                            nameInput.value = doctorName;
                            specialtyInput.value = specialty;
                        }

                        // Attach a click event listener to the "Book an Appointment" button
                        var appointmentButtons = document.querySelectorAll('[data-toggle="modal"]');
                        appointmentButtons.forEach(function(button) {
                            button.addEventListener('click', function() {
                                var doctorName = this.getAttribute('data-doctor-name');
                                var specialty = this.getAttribute('data-specialty');
                                var nameInputId = this.getAttribute('data-name-input-id');
                                var specialtyInputId = this.getAttribute('data-specialty-input-id');
                                updateModalInputs(doctorName, specialty, nameInputId, specialtyInputId);
                            });
                        });
                    </script>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>




    </div>
    <section class="contact-layout2 pt-0">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="contact-panel d-flex flex-wrap">

                        <?php echo $__env->make('frontend.pages.appointment', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <div
                            class="contact-panel__info d-flex flex-column justify-content-between bg-overlay bg-overlay-primary-gradient">
                            <div class="bg-img"><img src="assets/images/banners/1.jpg" alt="banner"></div>
                            <div>
                                <h4 class="contact-panel__title color-white">Quick Contacts</h4>
                                <p class="contact-panel__desc font-weight-bold color-white mb-30">Please feel free to
                                    contact our
                                    friendly staff with any medical enquiry.
                                </p>
                            </div>
                            <div>
                                <ul class="contact__list list-unstyled mb-30">
                                    <li>
                                        <i class="icon-phone"></i><a href="tel:+5565454117">Emergency Line: +91
                                            9625066751</a>
                                    </li>
                                    <li>
                                        <i class="icon-location"></i><a href="#">Location: Behind Huda Market
                                            Sector 46 Gurgaon Haryana 122001</a>
                                    </li>
                                    <li>
                                        <i class="icon-clock"></i><a href="contact-us.html">24X7 Open</a>
                                    </li>
                                </ul>
                                <a href="#" class="btn btn__white btn__rounded btn__outlined">Contact Us</a>
                            </div>
                        </div>
                    </div>
                </div><!-- /.col-lg-6 -->
                <div class="container">
                    <div class="row">
                        <?php echo $__env->make('frontend.pages.gallery', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <!-- /.col-xl-5 -->
                    </div><!-- /.row -->

                </div><!-- /.container -->
            </div><!-- /.row -->

        </div><!-- /.container -->
    </section>
    <!-- /.contact layout 2 -->
    <div class="container">
        <div class="row">
            <?php echo $__env->make('frontend.pages.videos', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- /.col-xl-5 -->
        </div><!-- /.row -->
        <style>
            .gallery-wrap {
                display: flex;
                flex-direction: row;
                width: 100%;
                height: 70vh;
            }

            .item {
                flex: 1;
                height: 100%;
                background-position: center;
                background-size: cover;
                background-repeat: none;
                transition: flex 0.8s ease;

                &:hover {
                    flex: 7;
                }
            }

            .item-1 {
                background-image: url('<?php echo e(asset('assets/images/babyPic/1.png')); ?>');
            }

            .item-2 {
                background-image: url('<?php echo e(asset('assets/images/babyPic/2.png')); ?>');
            }

            .item-3 {
                background-image: url('<?php echo e(asset('assets/images/babyPic/3.png')); ?>');
            }

            .item-4 {
                background-image: url('<?php echo e(asset('assets/images/babyPic/4.png')); ?>');
            }

            .item-5 {
                background-image: url('<?php echo e(asset('assets/images/babyPic/5.png')); ?>');
            }

            .social {
                position: absolute;
                right: 35px;
                bottom: 0;

                img {
                    display: block;
                    width: 32px;
                }
            }
        </style>
        <div class="col-12">
            <h3>New Born Baby</h3>

            <div class="gallery-wrap">
                <div class="item item-1"></div>
                <div class="item item-2"></div>
                <div class="item item-3"></div>
                <div class="item item-4"></div>
                <div class="item item-5"></div>
            </div>
        </div>

    </div>

    <div class="social">
        <a href="https://twitter.com/StefCharle" target="_blank">
            <img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/149103/twitter.svg" alt="">
        </a>
    </div>



    <!-- ======================
                                                                         Blog Grid
                                                                       ========================= -->
    <section class="blog-grid pb-50">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-6 offset-lg-3">
                    <div class="heading text-center mb-40">
                        <h3 class="heading__title">Free Health Camp</h3>
                    </div><!-- /.heading -->
                </div><!-- /.col-lg-6 -->
            </div><!-- /.row -->
            <div class="row">
<div class="col-sm-12 col-md-6 col-lg-4">
                        <div class="post-item">
                            <div class="post__img">
                                <a href="blog-single-post.html">
                                    <img src="<?php echo e(asset('assets/images/healthcancer.png')); ?>" alt="post image"
                                        class="card-img-top img-fluid" loading="lazy" style="width: 400px; height:300px">
                                </a>
                            </div><!-- /.post__img -->
                            <div class="post__body">
                                <div class="post__meta-cat">
                                    <a href="#">Madalasa Hospital </a>
                                </div><!-- /.blog-meta-cat -->
                                <div class="post__meta d-flex">
                                    <span class="post__meta-date">4th February | 9:30 - 1:00 PM</span>
                                    <a class="post__meta-author" href="#">Supported by : <br> Madalasa Foundation</a>
                                </div>
                                <h4 class="post__title"><a href=" "> Madalasa Hospital Cancer Screening Camp: Promoting Health and Well-being </a></h4>
                                <p class="post__desc" style="text-align: justify"> Greetings to all residents of Sector 46, Gurgaon! Madalasa Hospital, located in the heart of HUDA Market,
                                </p>
                                <a href=" "
                                    class="btn btn__secondary btn__link btn__rounded">
                                    Read More
                                    <i class="icon-arrow-right"></i>
                                </a>
                            </div><!-- /.post__body -->
                        </div><!-- /.post-item -->
                    </div>
                <!-- Post Item #1 -->
                <?php $__currentLoopData = $healthCamp; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $camp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-sm-12 col-md-6 col-lg-4">
                        <div class="post-item">
                            <div class="post__img">
                                <a href="blog-single-post.html">
                                    <img src="<?php echo e(asset('camp/images/' . $camp->campimage)); ?>" alt="post image"
                                        class="card-img-top img-fluid" loading="lazy" style="width: 400px; height:300px">
                                </a>
                            </div><!-- /.post__img -->
                            <div class="post__body">
                                <div class="post__meta-cat">
                                    <a href="#"><?php echo e($camp->location); ?></a>
                                </div><!-- /.blog-meta-cat -->
                                <div class="post__meta d-flex">
                                    <span class="post__meta-date"><?php echo e($camp->campdate); ?> <?php echo e($camp->camptime); ?></span>
                                    <a class="post__meta-author" href="#">Supported by : <br> Madalasa Foundation</a>
                                </div>
                                <h4 class="post__title"><a href="<?php echo e(route('healthcamp.showFront.show', ['id' => $camp->id])); ?>"> <?php echo e($camp->name); ?></a></h4>
                                <p class="post__desc" style="text-align: justify"> <?php echo e(substr($camp->des, 0, 100)); ?>..
                                </p>
                                <a href="<?php echo e(route('healthcamp.showFront.show', ['id' => $camp->id])); ?>"
                                    class="btn btn__secondary btn__link btn__rounded">
                                    Read More
                                    <i class="icon-arrow-right"></i>
                                </a>
                            </div><!-- /.post__body -->
                        </div><!-- /.post-item -->
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <!-- /.col-lg-4 -->

            </div><!-- /.row -->
        </div><!-- /.container -->
    </section><!-- /.blog Grid -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/public_html/resources/views/frontend/pages/index.blade.php ENDPATH**/ ?>