
<?php $__env->startSection('content'); ?>
    <section>
        <style>
            /* Add this CSS to your project */
.table-responsive {
    overflow-x: auto;
}

.doctors-timetable {
    width: 100%;
    border-collapse: collapse;
    border-spacing: 0;
}

.doctors-timetable th,
.doctors-timetable td {
    padding: 8px;
    text-align: left;
    vertical-align: top;
    border-top: 1px solid #dee2e6;
}

.doctors-timetable thead th {
    background-color: #f8f9fa;
    color: #343a40;
    font-weight: 600;
}

.doctors-timetable tbody tr:nth-child(even) {
    background-color: #f2f2f2;
}

.doctors-timetable tbody td {
    vertical-align: middle;
}

.availability {
    display: flex;
    flex-wrap: wrap;
    gap: 4px;
}

.available,
.not-available {
    padding: 2px 6px;
    border-radius: 4px;
    font-weight: 600;
}

.available {
    background-color: #28a745;
    color: #fff;
}

.not-available {
    background-color: #dc3545;
    color: #fff;
}

/* Media Query for Responsive Table */
@media (max-width: 767px) {
    .doctors-timetable thead {
        display: none;
    }

    .doctors-timetable tbody td {
        display: block;
        padding: 8px;
        text-align: center;
    }

    .doctors-timetable tbody td::before {
        content: attr(data-label);
        font-weight: 600;
        display: block;
    }
}

        </style>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="table-responsive">
                        <table class="doctors-timetable w-100">
                            <thead>
                                <tr>
                                    <th>Doctor</th>
                                    <th>Specialty</th>
                                     
                                    <th>Morning Timings</th>
                                    <th>Evening Timings</th>
                                    <th>Days</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $doctorTimetables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctorId => $doctorData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($doctorData['name']); ?></td>
                                        <td><?php echo e($doctorData['specialty']); ?></td>
                                        
                                        <td><?php echo e($doctorData['morningTiming']); ?></td>
                                        <td><?php echo e($doctorData['eveningTiming']); ?></td>
                                        <td>
                                            <div class="availability">
                                                <?php $__currentLoopData = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($doctorId == 7 || ($doctorId != 7 && !in_array($day, [ 'Sunday']))): ?>
                                                        <div class="available"><?php echo e($day); ?></div>
                                                    <?php else: ?>
                                                        <div class="not-available"><?php echo e($day); ?></div>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div><!-- /.col-12 -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </section><!-- /.Doctors Timetable -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/public_html/resources/views/frontend/pages/doctor/doctors-timetable.blade.php ENDPATH**/ ?>