<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
    <link rel="icon" type="image/jpeg" href="<?php echo e(asset('assets/images/favicon/fav.jpeg')); ?>">
    <title><?php echo $__env->yieldContent('title', 'Madalasa Hospital - Multispecialist Hospital in Sector 46, Gurgaon.'); ?></title>
    <meta name="title" content="<?php echo $__env->yieldContent('metaTitle', 'Madalasa Hospital - Multispecialist Hospital in Sector 46, Gurgaon.'); ?>">
    <meta name="description" content="<?php echo $__env->yieldContent('metaDescription', 'Madalasa Hospital - Multispecialist Hospital in Sector 46, Gurgaon.'); ?>">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Quicksand:wght@400;500;600;700&amp;family=Roboto:wght@400;700&amp;display=swap">
    <link rel="stylesheet" href="use.fontawesome.com/releases/v5.15.3/css/all.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/libraries.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">

    <!-- local business schema started-->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Hospital",
  "name": "Madalasa Hospital",
  "image": "https://madalasahospital.com/assets/images/logo/logo.png",
  "@id": "",
  "url": "https://madalasahospital.com/",
  "telephone": "9625066751",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Huda Market Sector 46",
    "addressLocality": "Gurgaon",
    "postalCode": "122001",
    "addressCountry": "IN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 28.4353354,
    "longitude": 77.0595361
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://www.facebook.com/MadalasaHospital",
    "https://twitter.com/MadalasaHospit",
    "https://www.instagram.com/madalasahospital/",
    "https://www.youtube.com/@MadalasaHospital",
    "https://www.linkedin.com/in/madalasa-hospital-4a02b5234/"
  ] 
}
</script>
    <!-- local business schema Ended-->
</head>

<body>

    <div class="wrapper">
        <?php echo $__env->make('frontend.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make('frontend.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php echo $__env->make('frontend.pages.button.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <!-- Bootstrap and jQuery Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
    <script src="<?php echo e(asset('assets/js/jquery-3.5.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>
</body>

</html>
<?php /**PATH /home2/madalozy/public_html/resources/views/frontend/layouts/master.blade.php ENDPATH**/ ?>