

<?php $__env->startSection('backendcontent'); ?>
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="doctors.html">Department</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Add Department</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('healthcamp.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Add Department Details &nbsp;&nbsp;&nbsp;<a href="<?php echo e(route('healthcamp.show')); ?>">View All Health Camp</a></h4>
                                    </div>
                                    <?php if(session()->has('success')): ?>
                                    <div class="alert alert-info">
                                        <?php echo e(session('success')); ?>

                                    </div>
                                    <?php endif; ?>
                                    <?php if($errors->any()): ?>
                                    <div class="alert alert-danger">
                                        <ul>
                                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="row">
                                     
                                        <div class="form-group local-forms col-md-4">
                                            <label>Camp. Name <span class="login-danger">*</span></label>
                                            <input class="form-control" name="name" value="<?php echo e(old('name')); ?>" type="text" placeholder="Free Health Camp">
                                        </div>
                                        <div class="form-group local-forms col-md-4">
                                            <label>Camp. Location <span class="login-danger">*</span></label>
                                            <input class="form-control" name="location" value="<?php echo e(old('location')); ?>" type="text" placeholder="Location">
                                        </div>
                                        <div class="form-group local-forms col-md-4">
                                            <label>Camp. Date <span class="login-danger">*</span></label>
                                            <input class="form-control" name="campdate" value="<?php echo e(old('campdate')); ?>" type="date"  >
                                        </div>
    
                                        <div class="form-group local-forms col-md-4">
                                            <label>Camp. Time <span class="login-danger">*</span></label>
                                            <input class="form-control" name="camptime" value="<?php echo e(old('camptime')); ?>" type="time"  >
                                        </div>
                                        <div class="form-group local-forms col-md-4">
                                            <label>Camp. Image <span class="login-danger">*</span></label>
                                            <input class="form-control" name="campimage" value="<?php echo e(old('campimage')); ?>" type="file"   accept="image/*">
                                        </div> <br>
                                        <div class="form-group local-forms col-md-12">
                                            <label>Camp. Des <span class="login-danger">*</span></label>
                                            <textarea name="des" id="" cols="30" rows="10" class="form-control"><?php echo e(old('des')); ?></textarea>
                                         </div>
    
                                    </div>
                                </div>
                               
                                <!-- Add other form fields here -->
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                        <button type="button" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Sartaj Akhtar\Downloads\well-known\resources\views/backend/admin/freeHealthCamp/create.blade.php ENDPATH**/ ?>