<?php

namespace App\Http\Controllers;

use App\Models\Appointment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AdminController extends Controller
{
    public function dashboard(Request $request)
    {
        $appointments = Appointment::get();
        $appointmentCount = $appointments->count();
        $recentAppointments = Appointment::orderBy('id', 'desc')->paginate(10);
        return view('backend.admin.dashboard', compact('appointments', 'appointmentCount', 'recentAppointments'));
    }



    public function updateAppointmentStatus($id, $status)
    {
        $validStatuses = ['done', 'pending', 'cancelled'];

        if (!in_array($status, $validStatuses)) {
            abort(400, 'Invalid status.');
        }

        DB::table('appointments')
            ->where('id', $id)
            ->update(['status' => $status]);

        $cssClass = 'status-green'; // Default class
        if ($status === 'pending') {
            $cssClass = 'status-yellow';
        } elseif ($status === 'cancelled') {
            $cssClass = 'status-red';
        }

        return redirect()->back()->with('status', 'Appointment status updated successfully.')
            ->with('cssClass', $cssClass);
    }
}
