<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function register(){
        return view('frontend.auth.register');
    }

    public function loginShow(){
        return view('frontend.auth.login');
    }

    public function store(Request $request)
{
    $validationData = $request->validate([
        'name' => 'required|string|max:255',
        'email' => 'required|email|unique:users,email', 
        'phone' => ['required', 'regex:/^\d{10}$/'],
        'password' => 'required',
    ]);

    $data = new User([
        'name' => $validationData['name'],
        'email' => $validationData['email'],
        'phone' => $validationData['phone'],
        'password' => Hash::make($validationData['password']),
        'role_id' => 0,
    ]);  

    $data->save();

    return redirect()->route('login.show')->with('success', 'You have been registered successfully! Now you can log in.');
}


public function login(Request $request){
     $credentails = $request->only('email','password');
     if(Auth::attempt($credentails)){
        $user = Auth::user();
        if($user->role_id ===1){
            return redirect()->route('admin.dashboard');

        }else{
            return redirect()->route('patient.dashboard');
        }
           
        
     }else{
        return back()->withErrors(['email' => 'Invalid credentials']);
     }

}


public function logout()
{
    Auth::logout();
    return redirect()->route('login.show')->with('success', 'You have been logged out.');
}




}
