<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\DoctorTimeTable;
class Doctor extends Model
{
    protected $fillable = [
        'doctorfname',
        'doctorlname',
        'specialty',
        'bio',
        'phone',
        'email',
        'gender',
        'image',
        'department_id',
    ];
    use HasFactory;
    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }

    public function doctorTimeTable(){
        return $this->belongsTo(DoctorTimeTable::class , 'doctor_id');
    }

    public function doctorSeo()
    {
        return $this->hasOne(DoctorSeo::class, 'doctor_id');
    }
}
