<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DoctorTimeTable extends Model
{
    use HasFactory;
    protected $fillable =[
        'morningTiming',
        'consultation',
        'eveningTiming',
        'department',
        'dname',
        'doctor_id',
        'department_id',
    ];

   // In your DoctorTimeTable model
public function doctor()
{
    return $this->belongsTo(Doctor::class, 'doctor_id');
}
// In your DoctorTimeTable model
public function department()
{
    return $this->belongsTo(Department::class, 'department_id');
}


    
}

