<?php

namespace App\Providers;

use App\Models\Department;
use App\Models\Doctor;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
 
class DepartmentComposerServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        View::composer('*', function ($view) {
            $doctors = Doctor::all();
            $departments = Department::all();
            $view->with(compact('doctors', 'departments'));
        });
    }
}
