@extends('backend.layouts.master')
@section('backendcontent')
    <style>
        .custom-badge.status-green {
            color: white !important;
            background-color: green !important;
        }

        .custom-badge.status-red {
            color: white;
            background-color: red;
        }

        .custom-badge.status-yellow {
            color: black;
            background-color: yellow;
        }
    </style>

    <div class="page-wrapper">
        <div class="content">
            <div class="page-header">
                <div class="row">
                    <div class="col-sm-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('admin.dashboard') }}">Dashboard </a>
                            </li>
                            <li class="breadcrumb-item">
                                <i class="feather-chevron-right"></i>
                            </li>
                            <li class="breadcrumb-item active">Admin Dashboard</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="good-morning-blk">
                <div class="row">
                    <div class="col-md-6">
                        <div class="morning-user">
                            <h2>Welcome, <span>Madalasa Hospital</span></h2>
                            <p>Have a nice day at work</p>
                        </div>
                    </div>
                    <div class="col-md-6 position-blk">
                        <div class="morning-img">
                            <img src={{ asset('backend/assets/img/morning-img-01.png') }} alt="" />
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                    <div class="dash-widget">
                        <div class="dash-boxs comman-flex-center">
                            <img src="{{ asset('backend/assets/img/icons/calendar.svg') }}" alt="" />
                        </div>
                        <div class="dash-content dash-count">
                            <h4>Appointments</h4>
                            <h2><span class="counter-up">{{ $appointmentCount }}</span></h2>
                            <p>
                                <span class="passive-view"><i class="feather-arrow-up-right me-1"></i>40%</span>
                                vs last month
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                    <div class="dash-widget">
                        <div class="dash-boxs comman-flex-center">
                            <img src="{{ asset('backend/assets/img/icons/profile-add.svg') }}" alt="" />
                        </div>
                        <div class="dash-content dash-count">
                            <h4>New Patients</h4>
                            <h2><span class="counter-up">140</span></h2>
                            <p>
                                <span class="passive-view"><i class="feather-arrow-up-right me-1"></i>20%</span>
                                vs last month
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                    <div class="dash-widget">
                        <div class="dash-boxs comman-flex-center">
                            <img src="{{ asset('backend/assets/img/icons/scissor.svg') }}" alt="" />
                        </div>
                        <div class="dash-content dash-count">
                            <h4>Operations</h4>
                            <h2><span class="counter-up">56</span></h2>
                            <p>
                                <span class="negative-view"><i class="feather-arrow-down-right me-1"></i>15%</span>
                                vs last month
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                    <div class="dash-widget">
                        <div class="dash-boxs comman-flex-center">
                            <img src="{{ asset('backend/assets/img/icons/empty-wallet.svg') }}" alt="" />
                        </div>
                        <div class="dash-content dash-count">
                            <h4>Earnings</h4>
                            <h2>$<span class="counter-up"> 20,250</span></h2>
                            <p>
                                <span class="passive-view"><i class="feather-arrow-up-right me-1"></i>30%</span>
                                vs last month
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12 col-xl-12">
                    <div class="card">
                        <div class="card-header pb-0">
                            <h4 class="card-title d-inline-block">Recent Appointment</h4>
                            <a href="patients.html" class="float-end patient-views">show all</a>
                        </div>
                        <div class="card-block table-dash">
                            <div class="table-responsive">
                                <table class="table mb-0 border-0 datatable custom-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                <div class="form-check check-tables">
                                                    <input class="form-check-input" type="checkbox" value="something" />
                                                </div>
                                            </th>
                                            <th>Patient name</th>
                                            <th>Doctor Name</th>
                                            
                                            <th>appt. Date</th>
                                            <th>appt. Time</th>
                                           
                                            <th>Status</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($recentAppointments as $appointment)
                                            <tr>
                                                <td>
                                                    <div class="form-check check-tables">
                                                        <input class="form-check-input" type="checkbox" value="something" />
                                                    </div>
                                                </td>
                                                <td class="table-image">
                                                    {{ $appointment->patientName }}
                                                </td>
                                                <td>{{ $appointment->doctorName }}</td>
                                                <td>{{ $appointment->appointmentdate }}</td>
                                                <td>{{ $appointment->appointmenttime }}</td>
                                                <td class="status-td" data-status="{{ $appointment->status }}">
                                                    <button
                                                        class="custom-badge 
                                                      @if ($appointment->status === 'done') status-green
                                                      @elseif ($appointment->status === 'cancelled') status-red
                                                      @elseif ($appointment->status === 'pending') status-yellow @endif"
                                                        data-status="{{ $appointment->status }}">
                                                        {{ $appointment->status }}
                                                    </button>
                                                </td>
                                                <td class="text-end">
                                                    <div class="dropdown dropdown-action">
                                                        <a href="#" class="action-icon dropdown-toggle"
                                                            data-bs-toggle="dropdown" aria-expanded="false"><i
                                                                class="fa fa-ellipsis-v"></i></a>
                                                        <div class="dropdown-menu dropdown-menu-end">
                                                            <a class="dropdown-item"
                                                                href="{{ route('update-appointment-status', ['id' => $appointment->id, 'status' => 'done']) }}"><i
                                                                    class="fa fa-check-circle m-r-5"></i> Done</a>
                                                            <a class="dropdown-item"
                                                                href="{{ route('update-appointment-status', ['id' => $appointment->id, 'status' => 'pending']) }}"><i
                                                                    class="fa fa-clock m-r-5"></i> Pending</a>
                                                            <a class="dropdown-item"
                                                                href="{{ route('update-appointment-status', ['id' => $appointment->id, 'status' => 'cancelled']) }}"><i
                                                                    class="fa fa-times-circle m-r-5"></i> Cancelled</a>
                                                                    <a class="dropdown-item" href="edit-patient.html"><i
                                                                      class="fa fa-pencil-alt m-r-5"></i> View</a>
                                                            <a class="dropdown-item" href="edit-patient.html"><i
                                                                    class="fa fa-pencil-alt m-r-5"></i> Edit</a>
                                                            <a class="dropdown-item" href="#" data-bs-toggle="modal"
                                                                data-bs-target="#delete_appointment"><i
                                                                    class="fa fa-trash-alt m-r-5"></i> Delete</a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
  
@endsection

