@extends('backend.layouts.master')

@section('backendcontent')
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="doctors.html">Department</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Add Department</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('healthcamp.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Add Department Details &nbsp;&nbsp;&nbsp;<a href="{{ route('healthcamp.show') }}">View All Health Camp</a></h4>
                                    </div>
                                    @if (session()->has('success'))
                                    <div class="alert alert-info">
                                        {{ session('success') }}
                                    </div>
                                    @endif
                                    @if ($errors->any())
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    @endif
                                </div>
                                <div class="row">
                                     
                                        <div class="form-group local-forms col-md-4">
                                            <label>Camp. Name <span class="login-danger">*</span></label>
                                            <input class="form-control" name="name" value="{{ old('name') }}" type="text" placeholder="Free Health Camp">
                                        </div>
                                        <div class="form-group local-forms col-md-4">
                                            <label>Camp. Location <span class="login-danger">*</span></label>
                                            <input class="form-control" name="location" value="{{ old('location') }}" type="text" placeholder="Location">
                                        </div>
                                        <div class="form-group local-forms col-md-4">
                                            <label>Camp. Date <span class="login-danger">*</span></label>
                                            <input class="form-control" name="campdate" value="{{ old('campdate') }}" type="date"  >
                                        </div>
    
                                        <div class="form-group local-forms col-md-4">
                                            <label>Camp. Time <span class="login-danger">*</span></label>
                                            <input class="form-control" name="camptime" value="{{ old('camptime') }}" type="time"  >
                                        </div>
                                        <div class="form-group local-forms col-md-4">
                                            <label>Camp. Image <span class="login-danger">*</span></label>
                                            <input class="form-control" name="campimage" value="{{ old('campimage') }}" type="file"   accept="image/*">
                                        </div> <br>
                                        <div class="form-group local-forms col-md-12">
                                            <label>Camp. Des <span class="login-danger">*</span></label>
                                            <textarea name="des" id="" cols="30" rows="10" class="form-control">{{old('des')}}</textarea>
                                         </div>
    
                                    </div>
                                </div>
                               
                                <!-- Add other form fields here -->
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                        <button type="button" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
