@extends('frontend.layouts.master')
 
@section('content')
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-8 offset-md-2">

                    <div class="account-content">
                        <div class="row align-items-center justify-content-center">
                            <div class="col-md-7 col-lg-6 login-left">
                                <img src="{{asset('backend/assets/img/login-02.png')}}" class="img-fluid" alt="Doccure Login">
                            </div>
                            <div class="col-md-12 col-lg-6 login-right">
                                <div class="login-header">
                                    <h4>Patient <span> Registration Form</span></h4>
                                </div>
                                <!-- Validation Errors -->
                                 <form method="POST" action="{{route('register.store')}}">
                                    @csrf
                                    <!-- Name -->
                                    @error('name')
                                        <span class="text-red-500">{{$message}}</span>
                                    @enderror
                                    <div class="form-group form-focus">
                                        <input type="text" name="name" class="form-control" placeholder="Name">
                                    </div>
                                    <!-- Email Address -->
                                    @error('email')
                                        <span class="text-red-500">{{$message}}</span>
                                    @enderror
                                    <div class="mt-4 form-group form-focus">
                                        <input type="email" name="email" class="form-control" placeholder="email">
                                    </div>
                                    @error('phone')
                                        <span class="text-red-500">{{$message}}</span>
                                    @enderror
                                    <div class="mt-4 form-group form-focus">
                                        <input type="phone" name="phone" class="form-control" placeholder="phone">
                                    </div>
                                    <!-- Password -->
                                    @error('password')
                                        <span class="text-red-500">{{$message}}</span>
                                    @enderror
                                    <div class="mt-4 form-group form-focus">
                                       <input type="password" name="password" class="form-control" placeholder="Password">
                                    </div>
                                    <!-- Confirm Password -->
                                    <div class="mt-4 form-group form-focus">
                                        <input type="password" name="password" class="form-control" placeholder="Password">
                                    </div>
                                    <button type="submit" class="btn btn-primary">Register Now</button>
                                    <a href="{{route('login.show')}}">- Already Registered User? Click here to login</a>
                                    
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
