@extends('frontend.layouts.master')
@section('title','About us - Madalasa Hospital')
@section('metaTitle','Madalasa Hospital - Premier Multispecialist Healthcare in Sector 46, Gurgaon')
@section('metaDescription','Discover comprehensive healthcare at Madalasa Hospital in Sector 46, Gurgaon. Our expert team offers specialized medical services, cutting-edge facilities, and compassionate care. Your health, our priority.')
@section('content')
    <section class="pt-120 pb-80">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-4">
                    <aside class="sidebar has-marign-right">
                        <div class="widget widget-member">
                            <div class="member mb-0">
                                <div class="member__img">
                                    <img src="{{ asset('assets/images/about/madalasa.png') }}" alt="member img">
                                </div><!-- /.member-img -->
                                <div class="member__info">
                                    <h5 class="member__name"><a href="doctors-single-doctor1.html">Madalasa Hospital</a>
                                    </h5>
                                    <p class="member__job">Best Multispeciality Hospitals</p>
                                    <p class="member__desc" style="text-align: justify">We welcomed 2020 with a rejuvenated
                                        brand name, changing from Suryadeep Hospital to Madālasā HOSPITAL (A unit of
                                        Suryadeep Hospitals Pvt Ltd). This is to further reinforce our commitment to the
                                        Hospital & Healthcare</p>
                                    <div class="mt-20 d-flex flex-wrap justify-content-between align-items-center">
                                        <ul class="social-icons list-unstyled mb-0">
                                            <li><a href="https://www.facebook.com/MadalasaHospital" class="facebook"><i
                                                        class="fab fa-facebook-f"></i></a></li>
                                            <li><a href="https://twitter.com/MadalasaHospit" class="twitter"><i
                                                        class="fab fa-twitter"></i></a></li>
                                            <a href=""><img width="48" height="48"
                                                    src="https://img.icons8.com/fluency/48/instagram-new.png"
                                                    alt="instagram-new" /></a>
                                            <a href=""><img width="48" height="48"
                                                    src="https://img.icons8.com/color/48/youtube-play.png"
                                                    alt="youtube-play" /></a>
                                            <a href=""><img width="48" height="48"
                                                    src="https://img.icons8.com/color/48/linkedin.png" alt="linkedin" /></a>
                                        </ul><!-- /.social-icons -->
                                    </div>
                                </div><!-- /.member-info -->
                            </div><!-- /.member -->
                        </div><!-- /.widget-member -->
                        <div class="widget widget-help bg-overlay bg-overlay-primary-gradient">
                            <div class="bg-img"><img src="assets/images/banners/5.jpg" alt="background"></div>
                            <div class="widget-content">
                                <div class="widget__icon">
                                    <i class="icon-call3"></i>
                                </div>
                                <h4 class="widget__title">Emergency Cases</h4>
                                <p class="widget__desc">Please feel welcome to contact our friendly reception staff with any
                                    general
                                    or medical enquiry call us.
                                </p>
                                <a href="tel:+919319661010" class="phone__number">
                                    <i class="icon-phone"></i> <span>+91 9319661010</span>
                                </a>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-help -->
                         

                    </aside><!-- /.sidebar -->
                </div><!-- /.col-lg-4 -->
                <div class="col-sm-12 col-md-12 col-lg-8">
                    <div class="text-block mb-50">
                        <h5 class="text-block__title"> Madalasa Hospital </h5>
                        <p class="text-block__desc mb-20 font-weight-bold color-secondary"> We welcomed 2020 with a
                            rejuvenated brand name, changing from Suryadeep Hospital to Madālasā HOSPITAL (A unit of
                            Suryadeep Hospitals Pvt Ltd). This is to further reinforce our commitment to the Hospital &
                            Healthcare.</p>

                        <p class="text-block__desc mb-20">

                            At Madalasa Hospital, we understand that your health is your most valuable asset, and we are
                            committed to safeguarding it. Located in the heart of Sector 46, Gurgaon, Madalasa Hospital is a
                            leading multispecialty healthcare facility dedicated to providing world-class medical services
                            to our community.
                        </p>

                        <!-- /.text-block -->
                        <div class="pricing-widget-layout3 mb-70">
                            <h5 class="pricing__title">Multispecialty Services

                            </h5>

                            <div class="row">
                                <div class="col-md-12">
                                    <ul class="pricing__list list-unstyled mb-0 horizontal-list">
                                        <li><span class="price">Internal Medicine</span> <span class="price">Gynecology
                                                and Obstetrics</span> <span class="price">Orthopaedics</span> <span
                                                class="price">Paediatrics</span> <span class="price">Surgery</span> </li>
                                        <li><span class="price">ENT</span><span class="price">Physiotherapy </span> <span
                                                class="price">Dialysis</span><span class="price">Dietitian</span><span
                                                class="price">Lab and X-Ray</span><span class="price">ICU & NICU</span>
                                        </li>
                                        
                                    </ul>
                                </div>
                            </div><!-- /.pricing-widget-layout3 -->
                        </div><!-- /.text-block -->
                        <div class="mission-vision-container">
                            <div class="row">
                                <div class="mission col-md-6">
                                    <h2>Mission</h2>
                                    <p style="text-align: justify">
                                      "At Madalasa Hospital, our mission is to provide accessible, high-quality healthcare that improves the well-being of our patients and community. We are committed to delivering compassionate, patient-centric medical services that promote healing, prevention, and holistic care. Our dedicated team of healthcare professionals strives to exceed expectations by continually enhancing our services and embracing the latest medical advancements. We are driven by a deep sense of responsibility to contribute positively to the health and happiness of the individuals and families we serve."
                                    </p>
                                  </div>
                                  <div class="vision col-md-6">
                                    <h2>Vision</h2>
                                    <p style="text-align: justify">
                                      "Our vision at Madalasa Hospital is to be the foremost healthcare institution in Sector 46, Gurgaon, and the surrounding areas, renowned for its excellence in patient care, clinical outcomes, and medical innovation. We aspire to create a healthcare environment where patients feel valued, empowered, and well-informed, leading to healthier lives and vibrant communities. We envision a future where Madalasa Hospital is a trusted partner in promoting wellness, serving as a beacon of hope and health in our region. By embracing cutting-edge technology, nurturing talent..
                                    </p>
                                  </div>
                            </div>
                           
                          </div>
                          
                        <h5 class="text-block__title">CARE – Care Always with Respect and Empathy.
                        </h5>
                        <p class="text-block__desc mb-20">We embrace these Values in our Behaviors 24*7 and demonstrate the
                            same in our every action. Queen Madālasā as mentioned in the Mārkańdeya Purāńa is our
                            inspiration. While singing melodious lullabies to her children she instils values selflessness &
                            purity in their action. Through her lyrics Queen Madālasā makes her children embrace the
                            ultimate truth and humane values in her children. She is the supreme embodiment of selfless love
                            and care. Inspired and guided by the action and words of Queen Madālasā, we too strive to
                            provide Care for the well-being of all with the sensitivity, sensibility and strength of a
                            Mother..</p>
                    </div><!-- /.text-block -->
                    <p class="text-block__desc">
                        Our Commitment to Patient-Centric Care

                        At Madalasa Hospital, patients are at the center of everything we do. We are dedicated to providing:

                        Compassion: We understand that seeking medical care can be a stressful experience. Our team is
                        committed to providing a compassionate and supportive environment.

                        Quality: We adhere to the highest standards of medical care. Our commitment to quality ensures that
                        you receive the best treatment possible.

                        Accessibility: We are conveniently located in Sector 46, Gurgaon, making it easy for you to access
                        our services when you need them most.

                        Collaboration: We work closely with patients and their families to make informed decisions about
                        their healthcare. Your voice matters, and we involve you in your treatment plan.
                    </p>
                </div><!-- /.col-lg-8 -->
            </div><!-- /.row -->
            
        </div><!-- /.container -->
        
    </section>
   
@endsection
