<?php

use App\Http\Controllers\AboutController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AppointmentController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\DoctorController;
use App\Http\Controllers\DoctorSeoController;
use App\Http\Controllers\DoctorTimeTableController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\HealthCampController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PatientFeedBackController;
use App\Http\Controllers\PatietnController;
use App\Http\Controllers\ServicesSeoController;
use App\Http\Controllers\WhatsAppController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});


Route::get('/send-whatsapp',[WhatsAppController::class, 'whatsapp']);

Route::get('/',[HomeController::class , 'index'])->name('index');
Route::get('register',[AuthController::class , 'register'])->name('register.show');
Route::post('register/store',[AuthController::class , 'store'])->name('register.store');
Route::get('login/show',[AuthController::class, 'loginShow'])->name('login.show');
Route::post('login',[AuthController::class ,'login'])->name('login');
Route::post('logout',[AuthController::class , 'logout'])->name('logout');
//Services
Route::get('services/{id}', [DepartmentController::class, 'show'])->name('service.show');
Route::get('service/icu', [DepartmentController::class, 'icu'])->name('icu.show');
Route::get('service/dietians', [DepartmentController::class, 'dietians'])->name('dietians.show');
Route::get('service/lab-xray', [DepartmentController::class, 'xRayLab'])->name('xRayLab.show');
//Doctor
Route::get('doctors/{id}', [DoctorController::class, 'show'])->name('doctor.show');
Route::get('doctors/all', [DoctorController::class, 'allDoctorForFronend'])->name('doctor.forFront.show');
Route::get('doctor/timetable',[DoctorTimeTableController::class , 'index'])->name('doctorTime.show');
//Appointment
Route::post('/appointments', [AppointmentController::class, 'store'])->name('appointments.store');
Route::get('contact',[HomeController::class , 'contact'])->name('contact.show');

Route::get('term&condition',[HomeController::class,'termCondition'])->name('term&condition.show');
Route::get('privacy',[HomeController::class,'privacy'])->name('privacy.show');
 

//HealthCamp
Route::get('healthCamp/{id}',[HealthCampController::class , 'showFront'])->name('healthcamp.showFront.show');

//feedbackform

//feedbackform
Route::get('feedbackform', [PatientFeedBackController::class, 'hospitalfeedback'])->name('hospitalfeedback.show');
Route::post('feedbackform', [PatientFeedBackController::class, 'store'])->name('hospitalfeedback.store');


//about routes
Route::get('about-us',[AboutController::class , 'about'])->name('about.show');
Route::get('mission',[AboutController::class , 'mission'])->name('mission.show');
Route::get('vision',[AboutController::class , 'vision'])->name('vision.show');
 
Route::middleware(['auth','admin'])->group(function(){
    Route::get('admin/dashboard',[AdminController::class, 'dashboard'])->name('admin.dashboard');

    //department
    Route::get('department/create',[DepartmentController::class , 'create'])->name('department.create');
    Route::post('department/store',[DepartmentController::class , 'store'])->name('department.store');
    Route::get('department/all',[DepartmentController::class , 'alldepartment'])->name('department.all');
    Route::get('department/edit/{id}',[DepartmentController::class , 'edit'])->name('department.edit');
    Route::post('department/update',[DepartmentController::class , 'update'])->name('department.update');
    Route::post('department/delete/{id}', [DepartmentController::class, 'delete'])->name('department.delete');

    //Doctors
    Route::get('doctor/create',[DoctorController::class ,'create'])->name('doctor.create');
    Route::post('doctor/store',[DoctorController::class ,'store'])->name('doctor.store');
    Route::get('doctor/edit/{id}',[DoctorController::class ,'edit'])->name('doctor.edit');
    Route::put('doctor/update/{id}', [DoctorController::class, 'update'])->name('doctor.update');
    Route::post('doctor/delete/{id}', [DoctorController::class, 'delete'])->name('doctor.delete');

    Route::get('doctor/all',[DoctorController::class ,'allDoctor'])->name('doctor.all');


    //Doctor Timing
    Route::get('doctor/timingtable',[DoctorTimeTableController::class , 'create'])->name('doctor.timetable.create');
    Route::post('doctor/timingtable',[DoctorTimeTableController::class , 'store'])->name('doctor.timetable.store');
    Route::get('doctor/timingtable/edit/{id}',[DoctorTimeTableController::class , 'edit'])->name('doctor.timetable.edit');
    Route::post('doctor/timingtable/update/{id}',[DoctorTimeTableController::class , 'update'])->name('doctor.timetable.update');
    Route::get('doctor/timetabel/show',[DoctorTimeTableController::class , 'showTimeTabel'])->name('doctor.timeTabel.show');

 
    //Gallery
    Route::get('gallery',[GalleryController::class , 'create'])->name('gallery.create');
    Route::post('/gallery/upload', [GalleryController::class, 'upload'])->name('gallery.upload');
 
    //heath Camp
    Route::get('free/health/camp', [HealthCampController::class, 'create'])->name('healthcamp.create');
    Route::post('healthCamp/store',[HealthCampController::class , 'store'])->name('healthcamp.store');
    Route::get('healthCamp/edit/{id}',[HealthCampController::class , 'edit'])->name('healthcamp.edit');
    Route::post('healthCamp/update/{id}',[HealthCampController::class , 'update'])->name('healthcamp.update');
    Route::get('healthCamp/show',[HealthCampController::class , 'show'])->name('healthcamp.show');

  


    Route::get('/update-appointment-status/{id}/{status}', [AdminController::class ,'updateAppointmentStatus'])
    ->name('update-appointment-status');

    //SEO ROUTES FOR DOCTORS

    Route::get('doctors/seo/create',[DoctorSeoController::class , 'create'])->name('doctor.seo.create');
    Route::post('doctors/seo/create',[DoctorSeoController::class , 'store'])->name('doctor.seo.store');

    //SEO ROUTES FOR SERVICES
    Route::get('services/seo/create',[ServicesSeoController::class , 'create'])->name('services.seo.create');
    Route::post('services/seo/store',[ServicesSeoController::class , 'store'])->name('services.seo.store');

});

Route::middleware(['auth','patient'])->group(function(){
    Route::get('patient/dashboard',[PatietnController::class ,'dashboard'])->name('patient.dashboard');
});



Route::get('free/health/camp/all', [HealthCampController::class, 'index'])->name('camp.index');


