
<?php $__env->startSection('content'); ?>
    <section id="content" class=" pb-80">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-8">
                    <div class="text-block mb-50">
                        <h5 class="text-block__title">ICU & NICU</h5>

                        <p class="text-block__desc mb-20" style="text-align: justify">
                            Madalasa Hospital is dedicated to providing exceptional care for critically ill patients and their families. Our Intensive Care Unit (ICU) and Neonatal Intensive Care Unit (NICU) are staffed by highly trained healthcare professionals who are committed to providing compassionate and comprehensive care.
                        </p>
                        <p class="text-block__desc mb-20">
                            EQUIPMENTS & INSTRUMENTS
                            Our ICU is equipped with state-of-the-art technology and advanced medical equipment to provide critical care for patients with life-threatening conditions. Our team of critical care specialists includes highly trained physicians, nurses, and other healthcare professionals who work together to provide personalized care for each patient. We offer advanced respiratory support, hemodynamic monitoring, and other specialized treatments to manage critically ill patients.
                            
                            Our NICU provides specialized care for premature babies and critically ill newborns. Our team of neonatologists, nurses, and other healthcare professionals work together to provide comprehensive care for these fragile patients. We offer specialized equipment and technologies to support the unique needs of our NICU patients, including respiratory support, intravenous therapy, and specialized nutrition support.
                            
                            At Madalasa Hospital, we understand that having a loved one in the ICU or NICU can be a stressful and emotional experience. Our team of healthcare professionals is committed to providing support and guidance to patients and their families during this challenging time. We offer family-centered care and encourage family members to be actively involved in their loved one's care.
                            
                            We also offer comprehensive rehabilitation and recovery services to help patients transition from critical care to recovery. Our rehabilitation services include physical therapy, occupational therapy, and speech therapy to help patients regain their strength and independence.
                            
                            If you or a loved one require critical care services, Madalasa Hospital is here to help. Our ICU and NICU are staffed by experienced healthcare professionals who are dedicated to providing compassionate and personalized care for our patients. We are committed to helping our patients achieve optimal health and well-being through advanced medical care, rehabilitation, and support.
                            
                            
                        </p>
                    </div>
                    <div class="text-block mb-50">
                        <h5 class="text-block__title">Our Core Values</h5>
                        <p class="text-block__desc mb-20" style="text-align: justify">
                            At Madalasa Hospital, our commitment to excellence is driven by a set of core values that guide
                            every aspect of our healthcare services. These values define who we are and what you can expect
                            from us:
                        </p>
                    </div><!-- /.text-block -->
                    <div class="fancybox-layout1">
                        <div class="row">
                            <div class="col-md-6">
                                <!-- fancybox item #1 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-heart"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Patient-Centered Care</h4>
                                        <p class="fancybox__desc"> At Madalasa Hospital, you are the center of our care. We
                                            listen to your concerns, respect your choices</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #2 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-doctor"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Excellence</h4>
                                        <p class="fancybox__desc">We are committed to excellence in healthcare. Our hospital
                                            is equipped with state-of-the-art facilities</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #3 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-call3"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Emergency Help 24/7 </h4>
                                        <p class="fancybox__desc">Contact our reception staff with any medical enquiry any
                                            time for low
                                            cost coverage adults.</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <!-- fancybox item #4 -->
                                <div class="fancybox-item d-flex">
                                    <div class="fancybox__icon">
                                        <i class="icon-doctor"></i>
                                    </div><!-- /.fancybox__icon -->
                                    <div class="fancybox__content">
                                        <h4 class="fancybox__title">Integrity </h4>
                                        <p class="fancybox__desc">All medical aspects practice for family, our reception
                                            staff with any
                                            medical enquiry any time.</p>
                                    </div><!-- /.fancybox-content -->
                                </div><!-- /.fancybox-item -->
                            </div><!-- /.col-md-6 -->
                        </div><!-- /.row -->
                    </div><!-- /.fancybox-layout1 -->
                  
                    <!-- /.text-block -->
                      <div id="accordion" class="mb-70">
                        <div class="accordion-item opened">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse3">
                                <a class="accordion__title" href="#">What are the visiting hours at Madalasa
                                    Hospital?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse3" class="collapse show" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p> Our hospital is open 24/7, and visitors are welcome at any time. However, we do
                                        recommend checking with specific departments or patient wards for any restrictions
                                        or guidelines related to visiting patients.</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse1">
                                <a class="accordion__title" href="#">Do you accept insurance plans, and which
                                    ones?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse1" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>Yes, we accept a variety of insurance plans. To ensure your insurance is accepted, we
                                        recommend contacting our billing department or checking our website for a list of
                                        accepted insurance providers. Our team is also available to assist you with
                                        insurance-related queries. Call Us: - <a href="tel:+919625066751">+91
                                            9625066751</a> &nbsp; &nbsp;<a href="tel:+9193196 61010">+91 93196 61010</a>
                                        &nbsp; &nbsp;<a href="<?php echo e(route('contact.show')); ?>">Get in touch</a></p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse2">
                                <a class="accordion__title" href="#">How can I reach Madalasa Hospital from the
                                    nearest public transportation hub?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse2" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p>Madalasa Hospital is conveniently located behind Huda Market in Sector 46, Gurgaon.
                                        You can easily reach us by taking a local bus, auto-rickshaw, or cab from the
                                        nearest metro station or bus stop. Our hospital's address is <a
                                            href="https://maps.app.goo.gl/FdRWbuUSivKP7VYd9"> Get Direction</a>, making it
                                        accessible for patients and visitors.</p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->
                        <div class="accordion-item">
                            <div class="accordion__header" data-toggle="collapse" data-target="#collapse4">
                                <a class="accordion__title" href="#">What specialized treatments or procedures are
                                    available at Madalasa Hospital?</a>
                            </div><!-- /.accordion-item-header -->
                            <div id="collapse4" class="collapse" data-parent="#accordion">
                                <div class="accordion__body">
                                    <p> Madalasa Hospital offers a wide range of specialized treatments and procedures,
                                        including advanced surgeries, diagnostic services, and specialized clinics for
                                        specific medical conditions. To learn more about our specialized services, you can
                                        visit our <a href="<?php echo e(route('index')); ?>">"Services"</a></p>
                                </div><!-- /.accordion-item-body -->
                            </div>
                        </div><!-- /.accordion-item -->

                    </div>

                </div><!-- /.col-lg-8 -->
            
                    <div class="col-sm-12 col-md-12 col-lg-4">
                    <aside class="sidebar has-marign-left sticky-top">
                        <div class="widget widget-services">
                            <h5 class="widget__title">Medical Services</h5>
                            <div class="widget-content">
                                <ul class="list-unstyled mb-0">
                                    <?php $__currentLoopData = $department; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $services): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e(route('service.show',['id'=>$services->id])); ?>"><span><?php echo e($services->name); ?></span><i
                                        class="icon-arrow-right"></i></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-services -->
                         <div class="widget widget-help bg-overlay bg-overlay-secondary-gradient">
                            <div class="bg-img"><img src="<?php echo e(asset('assetsimages/banners/5.jpg')); ?>" alt="background">
                            </div>
                            <div class="widget-content">
                                <div class="widget__icon">
                                    <i class="icon-call3"></i>
                                </div>
                                <h4 class="widget__title">Emergency Cases</h4>
                                <p class="widget__desc">Please feel welcome to contact our friendly reception staff with
                                    any general
                                    or medical enquiry call us.
                                </p>
                                <a href="tel:+919319661010" class="phone__number">
                                    <i class="icon-phone"></i> <span><a href="tel:+919319661010" style="color: white">+91 9319661010</a></span>
                                </a>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-help -->
                        <div class="widget widget-schedule">
                            <div class="widget-content">
                                <div class="widget__icon">
                                    <i class="icon-charity2"></i>
                                </div>
                                <h4 class="widget__title">Opening Hours</h4>
                                <ul class="time__list list-unstyled mb-0">
                                    <li><span>24X7 OPEN</span></li>

                                </ul>
                            </div><!-- /.widget-content -->
                        </div><!-- /.widget-schedule -->

                    </aside><!-- /.sidebar -->
                </div><!-- /.col-lg-4 -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/public_html/resources/views/frontend/pages/services/icu.blade.php ENDPATH**/ ?>